package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.utilities.*;

import java.util.*;

public class SubstringNode extends RenderNode
{
	private final String nodeContent;
	protected String firstParameter;
	protected String secondParameter;
	protected String thirdParameter;

	@Override
	public List<String> collectVariables()
	{
		return Arrays.asList(firstParameter, secondParameter, thirdParameter);
	}

	public SubstringNode(String nodeContent)
	{
		this.nodeContent = nodeContent;
		String innerString = StringUtils.getInnerString(nodeContent, "(", ")");
		List<String> parts = StringUtils.csvLineToList(innerString);
		if (!parts.isEmpty())
			firstParameter = parts.get(0);
		if (parts.size() > 1)
			secondParameter = parts.get(1);
		if (parts.size() > 2)
			thirdParameter = parts.get(2);
	}

	@Override
	public boolean isLeafNode()
	{
		return true;
	}

	@Override
	public String describe()
	{
		return "{" + nodeContent + "}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		if (ObjectChecker.isEmptyOrNull(firstParameter))
			return;
		String str = ObjectChecker.toStringOrEmpty(renderer.evalConstantOrVar(firstParameter, helper, currentLineNumber, insideCreator(), this));
		if (ObjectChecker.isEmptyOrNull(str))
			return;
		String startStr = "0";
		if (ObjectChecker.isNotEmptyOrNull(secondParameter))
			startStr = ObjectChecker.toStringOrEmpty(renderer.evalConstantOrVar(secondParameter, helper, currentLineNumber, insideCreator(), this));
		String lenStr = str.length() + "";
		if (ObjectChecker.isNotEmptyOrNull(thirdParameter))
			lenStr = ObjectChecker.toStringOrEmpty(renderer.evalConstantOrVar(thirdParameter, helper, currentLineNumber, insideCreator(), this));
		int start = renderer.parseInt(startStr);
		start = Math.max(start, 0);
		int len = renderer.parseInt(lenStr);
		if (len < 0)
			len = str.length();
		int endIndex = Math.min(str.length(), start + len);
		builder.append(str, start, endIndex);
	}
}
