package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.utilities.ObjectChecker;

public class TableRowNode extends PrefixSuffixCompositeNode
{
	public TableRowNode(String nodeContent)
	{
		super(nodeContent);
	}

	@Override
	public boolean shouldSubNodeEndThis(RenderNode subNode)
	{
		return subNode instanceof TableRowNode;
	}

	@Override
	protected Object prefix(RendererPropertyResolver helper, int currentLineNumber)
	{
		return "\n<tr>";
	}

	@Override
	protected Object suffix(RendererPropertyResolver helper, int currentLineNumber)
	{
		return "\n</tr>";
	}

	@Override
	public boolean isMyEnder(String nodeContent)
	{
		return ObjectChecker.areEqual(nodeContent, "endrow");
	}
}
