package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.constants.Language;
import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.utilities.*;
import com.namasoft.common.utils.translation.TranslationUtil;

import java.util.*;

public class TafqeetNode extends RenderNode
{
	private final String nodeContent;
	protected String firstParameter;
	protected String secondParameter;

	@Override
	public List<String> collectVariables()
	{
		return Arrays.asList(firstParameter, secondParameter);
	}

	public TafqeetNode(String nodeContent)
	{
		this.nodeContent = nodeContent;
		String innerString = StringUtils.getInnerString(nodeContent, "(", ")");
		List<String> parts = StringUtils.csvLineToList(innerString);
		if (!parts.isEmpty())
			firstParameter = parts.get(0);
		if (parts.size() > 1)
			secondParameter = parts.get(1);
	}

	@Override
	public boolean isLeafNode()
	{
		return true;
	}

	@Override
	public String describe()
	{
		return "{" + nodeContent + "}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		if (ObjectChecker.isEmptyOrNull(firstParameter))
			return;
		helper.tafqeet(renderer.evalConstantOrVar(firstParameter, helper, currentLineNumber, insideCreator(), this),
				renderer.evalConstantOrVar(secondParameter, helper, currentLineNumber, insideCreator(), this), builder, getLanguage());
	}

	protected Language getLanguage()
	{
		return TranslationUtil.getCurrentLanguage();
	}
}
