package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.utilities.ObjectChecker;

public class TempoNode extends RenderNode
{

	private final String nodeContent;

	public TempoNode(String nodeContent)
	{
		this.nodeContent = nodeContent;
	}

	@Override
	public boolean isLeafNode()
	{
		return false;
	}

	@Override
	public String describe()
	{
		return "{" + nodeContent + "}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		StringBuilder tempo = new StringBuilder();
		renderSubNodes(tempo, helper, currentLineNumber);
		StringBuilder renderedTempo = ComplexRenderer.parse(tempo.toString()).render(helper);
		builder.append(renderedTempo);
	}

	@Override
	public boolean isMyEnder(String nodeContent)
	{
		return ObjectChecker.areEqual(nodeContent, "endtempo");
	}
}
