package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;

public class TextNode extends RenderNode
{
	@Override
	public boolean canHaveText()
	{
		return true;
	}

	@Override
	public boolean isLeafNode()
	{
		return true;
	}

	@Override
	public String describe()
	{
		return '"' + getTextPart() + '"';
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		if (insideCreator())
			builder.append(getTextPart().trim());
		else
			builder.append(getTextPart());
	}
}
