package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.utilities.StringUtils;
import com.namasoft.common.utils.ServerNamaRep;

import java.util.*;

public class TimeNode extends RenderNode
{
	private final String nodeContent;
	protected final String valueExpression;

	@Override
	public List<String> collectVariables()
	{
		return Collections.singletonList(valueExpression);
	}

	public TimeNode(String nodeContent)
	{
		this.nodeContent = nodeContent;
		this.valueExpression = StringUtils.getInnerString(nodeContent, "(", ")");
	}

	@Override
	public String describe()
	{
		return "{" + nodeContent + "}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		builder.append(ServerNamaRep.timeToString(renderer.evalConstantOrVar(valueExpression, helper, currentLineNumber, insideCreator(), this)));
	}

	@Override
	public boolean isLeafNode()
	{
		return true;
	}
}
