package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.constants.Language;
import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.layout.edit.NaMaText;
import com.namasoft.common.utilities.StringUtils;
import com.namasoft.common.utils.translation.TranslationUtil;

import java.util.*;

public class TranslateNode extends RenderNode
{
	private final String nodeContent;
	private final String valueExpression;

	@Override
	public List<String> collectVariables()
	{
		return Collections.singletonList(valueExpression);
	}

	public TranslateNode(String nodeContent)
	{
		this.nodeContent = nodeContent;
		this.valueExpression = StringUtils.getInnerString(nodeContent, "(", ")");
	}

	@Override
	public String describe()
	{
		return "{" + nodeContent + "}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		builder.append(TranslationUtil.translate(
				NaMaText.resource(renderer.evalConstantOrVar(valueExpression, helper, currentLineNumber, insideCreator(), this)), getLang()));
	}

	protected Language getLang()
	{
		return ComplexRenderer.HELPER.getLanguage();
	}

	@Override
	public boolean isLeafNode()
	{
		return true;
	}
}
