package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.utilities.*;

import java.util.*;

public class VarNode extends RenderNode
{
	private final String varName;
	private Integer index;

	@Override
	public List<String> collectVariables()
	{
		return Collections.singletonList(varName);
	}

	public VarNode(String nodeContent)
	{
		List<String> parts = StringUtils.csvLineToList(nodeContent);
		this.varName = parts.get(0);
		if (parts.size() > 1)
		{
			index = ObjectChecker.tryParseInt(parts.get(1));
			if (index == null)
				index = 0;
			else
				index = index - 1;
		}
	}

	@Override
	public boolean isLeafNode()
	{
		return true;
	}

	@Override
	public String describe()
	{
		return "{" + varName + "}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		if (renderer.isDynamicCriteria())
			builder.append(helper.marshalInString(helper.resolveObject(varName, ObjectChecker.getFirstNotNullObj(index, currentLineNumber))));
		else
			builder.append(helper.resolve(varName, ObjectChecker.getFirstNotNullObj(index, currentLineNumber), insideCreator(), this));
	}
}
