package com.namasoft.common.layout;

import java.io.Serializable;

import jakarta.xml.bind.annotation.XmlTransient;

import com.namasoft.common.utilities.NamaObject;
import com.namasoft.common.utilities.ObjectChecker;

public class Owner implements Serializable, NamaObject
{

	private static final long serialVersionUID = 7208604289281866470L;
	private OwnerType ownerType;
	private String ownerId;

	public Owner(OwnerType type, String ownerId)
	{
		this();
		this.ownerId = ownerId;
		this.ownerType = type;
	}

	public Owner()
	{
	}

	public OwnerType getOwnerType()
	{
		return ownerType;
	}

	public void setOwnerType(OwnerType ownerType)
	{
		this.ownerType = ownerType;
	}

	public String getOwnerId()
	{
		return ownerId;
	}

	public void setOwnerId(String ownerId)
	{
		this.ownerId = ownerId;
	}

	public Owner id(String ownerId)
	{
		setOwnerId(ownerId);
		return this;
	}

	public Owner type(OwnerType type)
	{
		setOwnerType(type);
		return this;
	}

	public static Owner entity(String entityType)
	{
		return new Owner(OwnerType.Entity, entityType);
	}

	public static Owner other(String id)
	{
		return new Owner(OwnerType.Other, id);
	}

	@Override
	@XmlTransient
	public boolean isEmpty()
	{
		return ObjectChecker.areAllEmptyOrNull(getOwnerId(), getOwnerType());
	}
}
