package com.namasoft.common.layout;

import com.namasoft.common.utilities.ObjectChecker;

public enum WidgetState
{
	Enabled, Disabled, Invisible;
	public static WidgetState fromBoolean(Boolean state)
	{
		return ObjectChecker.isTrue(state) ? Enabled : Disabled;
	}

	public static WidgetState showHide(Boolean state)
	{
		return ObjectChecker.isTrue(state) ? Enabled : Invisible;
	}

	public boolean isEnabled()
	{
		return equals(Enabled);
	}
}
