package com.namasoft.common.layout.edit;

import java.util.ArrayList;
import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.HasIDUtil;

@XmlRootElement
@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class EditScreenGroup extends EditScreenBlock
{
	private List<EditScreenField> fields = new ArrayList<EditScreenField>();

	public boolean getEditScreenGroup()
	{
		return true;
	}

	@XmlElementWrapper(name = "fields")
	@XmlElement(name = "field")
	public List<EditScreenField> getFields()
	{
		return fields;
	}

	public void setFields(List<EditScreenField> fields)
	{
		this.fields = fields;
	}

	public EditScreenGroup addFields(String... ids)
	{
		for (String id : ids)
		{
			addField().id(id);
		}
		return this;
	}

	public EditScreenField addField()
	{
		return addField(new EditScreenField());
	}

	public EditScreenField addField(EditScreenField screenField)
	{
		getFields().add(screenField);
		return screenField;
	}

	public EditScreenField addField(String screenField)
	{
		return addField().id(screenField);
	}

	public EditScreenGroup title(NaMaText text)
	{
		setTitle(text);
		return this;
	}

	public EditScreenGroup title(String resrource)
	{
		setTitle(NaMaText.resource(resrource));
		return this;
	}

	public EditScreenGroup showInQuickCreate()
	{
		setShowInQuickCreate(true);
		return this;
	}

	public EditScreenGroup doNoShowInQuickCreate()
	{
		setShowInQuickCreate(false);
		return this;
	}

	public EditScreenField find(String fieldId)
	{
		return HasIDUtil.find(fieldId, getFields());
	}

	public EditScreenGroup removeField(String id)
	{
		EditScreenField field = HasIDUtil.find(id, getFields());
		getFields().remove(field);
		return this;
	}

	@Override
	public List<String> subFieldsIds()
	{
		List<String> fields = new ArrayList<>();
		for (EditScreenField field : getFields())
		{
			if (field instanceof CompositeEditScreenField)
				fields.addAll(HasIDUtil.getIds(((CompositeEditScreenField) field).getSubFields()));
			else
				fields.add(field.getId());
		}
		return fields;
	}
}
