package com.namasoft.common.layout.edit;

import com.namasoft.common.layout.list.crosstab.CrossTableBlock;
import com.namasoft.common.utilities.*;
import jakarta.xml.bind.annotation.*;

import java.io.Serializable;
import java.util.*;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class EditScreenPage implements Serializable, ShowableInQuickCreate
{
	private NaMaText title;
	private boolean showInQuickCreate = true;
	private List<EditScreenBlock> blocks = new ArrayList<EditScreenBlock>();
	private List<String> relatedToFeature = null;
	private String iconCode;

	public NaMaText getTitle()
	{
		if (title == null)
			title = NaMaText.resource("");
		return title;
	}

	public void setTitle(NaMaText text)
	{
		this.title = text;
	}

	@XmlElementWrapper(name = "blocks")
	@XmlElement(name = "block")
	public List<EditScreenBlock> getBlocks()
	{
		return blocks;
	}

	public void setBlocks(List<EditScreenBlock> groups)
	{
		this.blocks = groups;
	}

	@Override
	public boolean isShowInQuickCreate()
	{
		return showInQuickCreate;
	}

	public void setShowInQuickCreate(boolean showInQuickCreate)
	{
		this.showInQuickCreate = showInQuickCreate;
	}

	public List<String> getRelatedToFeature()
	{
		return relatedToFeature;
	}

	public void setRelatedToFeature(List<String> relatedToFeature)
	{
		this.relatedToFeature = relatedToFeature;
	}

	public EditScreenPage title(NaMaText text)
	{
		setTitle(text);
		return this;
	}

	public EditScreenPage title(String resrource)
	{
		setTitle(NaMaText.resource(resrource));
		return this;
	}

	public EditScreenGroup addGroup()
	{
		EditScreenGroup screenGroup = new EditScreenGroup();
		getBlocks().add(screenGroup);
		return screenGroup;
	}

	public CrossTableBlock addCrossTable()
	{
		CrossTableBlock crossTable = new CrossTableBlock();
		getBlocks().add(crossTable);
		return crossTable;
	}

	public EditScreenGrid addGrid()
	{
		EditScreenGrid screenGrid = new EditScreenGrid();
		getBlocks().add(screenGrid);
		return screenGrid;
	}

	public List<EditScreenField> listAllNormalFields()
	{
		ArrayList<EditScreenField> fields = new ArrayList<EditScreenField>();
		for (EditScreenBlock block : getBlocks())
		{
			if (block instanceof EditScreenGroup)
				fields.addAll(((EditScreenGroup) block).getFields());
		}
		return fields;
	}

	public List<EditScreenGridColumn> listAllColumnFields()
	{
		ArrayList<EditScreenGridColumn> fields = new ArrayList<EditScreenGridColumn>();
		for (EditScreenBlock block : getBlocks())
		{
			if (block instanceof EditScreenGrid)
				fields.addAll(((EditScreenGrid) block).getColumns());
		}
		return fields;
	}

	public EditScreenBlock addBlock()
	{
		EditScreenBlock block = new EditScreenBlock();
		getBlocks().add(block);
		return block;
	}

	public EditScreenList addList()
	{
		EditScreenList block = new EditScreenList();
		getBlocks().add(block);
		return block;
	}

	public EditScreenActionsBlock addActionsBlock()
	{
		EditScreenActionsBlock block = new EditScreenActionsBlock();
		getBlocks().add(block);
		return block;
	}

	public EditScreenPage showInQuickCreate()
	{
		setShowInQuickCreate(true);
		return this;
	}

	public EditScreenPage doNoShowInQuickCreate()
	{
		setShowInQuickCreate(false);
		return this;
	}

	public EditScreenPage relatedToFeatures(String... relatedToFeature)
	{
		setRelatedToFeature(CollectionsUtility.asList(relatedToFeature));
		return this;
	}

	public String getIconCode()
	{
		return iconCode;
	}

	public void setIconCode(String iconCode)
	{
		this.iconCode = iconCode;
	}

	public EditScreenPage withIcon()
	{
		setIconCode("nm-" + getTitle().getResourceId().toLowerCase());
		return this;
	}

	public void updateIconCodeIfNotEmpty(Object iconCode)
	{
		if (ObjectChecker.isEmptyOrNull(iconCode))
			return;
		setIconCode(ObjectChecker.toStringOrNull(iconCode));
	}
}
