package com.namasoft.common.layout.edit;

import com.namasoft.common.layout.ActionPlaceholder;
import com.namasoft.common.utilities.ObjectChecker;

@SuppressWarnings("serial")
public class GUIActionPlaceholder extends EditScreenField implements ActionPlaceholder
{
	private CustomizedGUIActionInfo customization;
	private boolean hideInNewGUI = false;
	public static GUIActionPlaceholder of(String id)
	{
		GUIActionPlaceholder editScreenField = new GUIActionPlaceholder();
		editScreenField.setId(id);
		return editScreenField;
	}

	public GUIActionPlaceholder id(String id)
	{
		setId(id);
		return this;
	}

	public GUIActionPlaceholder hideInNewGUI()
	{
		setHideInNewGUI(true);
		return this;
	}

	public GUIActionPlaceholder title(NaMaText title)
	{
		setTitle(title);
		return this;
	}

	public GUIActionPlaceholder showInQuickCreate()
	{
		setShowInQuickCreate(true);
		return this;
	}

	public GUIActionPlaceholder doNoShowInQuickCreate()
	{
		setShowInQuickCreate(false);
		return this;
	}

	@Override
	public CustomizedGUIActionInfo getCustomization()
	{
		if (customization == null)
			customization = new CustomizedGUIActionInfo();
		return customization;
	}

	public void setCustomization(CustomizedGUIActionInfo customization)
	{
		this.customization = customization;
	}

	@Override
	public boolean shouldBeAdded()
	{
		return ObjectChecker.isNotEmptyOrNull(getId()) || ObjectChecker.isNotEmptyOrNull(getCustomization());
	}

	public boolean isHideInNewGUI()
	{
		return hideInNewGUI;
	}

	public void setHideInNewGUI(boolean hideInNewGUI)
	{
		this.hideInNewGUI = hideInNewGUI;
	}
}
