package com.namasoft.common.layout.list;

import java.util.ArrayList;
import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;

import com.namasoft.common.layout.edit.NaMaText;
import com.namasoft.common.layout.metadata.FieldMetaData;

@XmlAccessorType(XmlAccessType.PROPERTY)
@SuppressWarnings("serial")
public class CriteriaField extends FilterField
{
	public CriteriaField(String id, NaMaText title)
	{
		super(id, title);
	}

	public CriteriaField()
	{
		super();
	}

	public CriteriaField(String id, FieldMetaData metaData)
	{
		this(id);
		setMetaData(metaData);
	}

	public CriteriaField(String id)
	{
		this(id, (NaMaText) null);
	}

	public static List<CriteriaField> of(String... fieldIds)
	{
		ArrayList<CriteriaField> list = new ArrayList<CriteriaField>();
		for (String fieldId : fieldIds)
		{
			list.add(new CriteriaField(fieldId));
		}
		return list;
	}
}
