package com.namasoft.common.layout.list;

import java.util.ArrayList;
import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;

import com.namasoft.common.utilities.ObjectChecker;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
/**
 * 
 * @author qasid
 * You need to put markers for order by column names as <b>
 * <code>[order]</code></b> <br/>
 * and a marker for criteria as <b><code>[criteria]</code></b> <br/>
 * You need also to put markers for question fields as
 * <code><b>[<i>question_field_id<i>]</b></code>
 * 
 */
public class DTOListViewQuery extends DTOQuery
{

	private List<ListQueryColumn> columns = new ArrayList<ListQueryColumn>();

	@XmlElementWrapper(name = "columns")
	@XmlElement(name = "column")
	public List<ListQueryColumn> getColumns()
	{
		return columns;
	}

	public void setColumns(List<ListQueryColumn> columns)
	{
		this.columns = columns;
	}

	public int indexOf(String columnId)
	{
		for (int i = 0; i < getColumns().size(); i++)
			if (ObjectChecker.areEqual(getColumns().get(i).getId(), columnId))
				return i;
		return -1;
	}

}
