package com.namasoft.common.layout.list;

import com.namasoft.common.criteria.AllowedValue;
import com.namasoft.common.layout.TitledID;
import com.namasoft.common.layout.edit.*;
import com.namasoft.common.layout.metadata.*;
import com.namasoft.common.utilities.ObjectChecker;

import jakarta.xml.bind.annotation.*;
import java.io.Serializable;
import java.util.List;

@XmlAccessorType(XmlAccessType.PROPERTY)
@SuppressWarnings("serial")
public abstract class FilterField implements Serializable, TitledID
{
	private NaMaText title;
	private String id;
	private List<AllowedValue> allowedValues;
	private BasicFieldMetaData metaData;
	private String domainClassName;
	private String criteriaExpression;
	private EditScreenFieldLayout layout;
	private boolean required = false;
	private String requiredGroup;
	private Boolean hijri;
	private Boolean list;
	private Boolean doNotAutoShowList;
	private Boolean onListOkRunAction;
	private Boolean onOkKeepSelectedItemsOnly;
	private String suggestionQuery;
	private String fromParam;
	private String fromParamMaxGapInDays;
	private CmnFieldFilteringParams  fieldFilteringParams;
	public FilterField(String id, NaMaText title)
	{
		setId(id);
		setTitle(title);
	}

	public FilterField()
	{
		super();
	}

	@Override
	public NaMaText getTitle()
	{
		return title;
	}

	public void setTitle(NaMaText title)
	{
		this.title = title;
	}

	@Override
	public String getId()
	{
		return id;
	}

	public void setId(String id)
	{
		this.id = id;
	}

	@XmlElementWrapper(name = "allowedValues")
	@XmlElement(name = "allowedValue")
	public List<AllowedValue> getAllowedValues()
	{
		return allowedValues;
	}

	public void setAllowedValues(List<AllowedValue> allowedValues)
	{
		this.allowedValues = allowedValues;
	}

	public BasicFieldMetaData getMetaData()
	{
		return metaData;
	}

	public void setMetaData(BasicFieldMetaData metaData)
	{
		this.metaData = metaData;
	}

	public String getDomainClassName()
	{
		return domainClassName;
	}

	public void setDomainClassName(String domainClassName)
	{
		this.domainClassName = domainClassName;
	}

	public boolean hasAllowedValues()
	{
		return ObjectChecker.isNotEmptyOrNull(getAllowedValues()) || FieldType.Enum.equals(getMetaData().getFieldType())
				|| FieldType.EntityType.equals(getMetaData().getFieldType());
	}

	@XmlTransient
	public FieldType getFieldType()
	{
		if (getMetaData() == null)
			return null;
		return getMetaData().getFieldType();
	}

	public String getCriteriaExpression()
	{
		return criteriaExpression;
	}

	public void setCriteriaExpression(String criteriaExpression)
	{
		this.criteriaExpression = criteriaExpression;
	}

	public EditScreenFieldLayout getLayout()
	{
		return layout;
	}

	public void setLayout(EditScreenFieldLayout layout)
	{
		this.layout = layout;
	}

	public boolean isRequired()
	{
		return required;
	}

	public void setRequired(boolean required)
	{
		this.required = required;
	}

	public void setHijri(Boolean hijri)
	{
		this.hijri = hijri;
	}

	public Boolean getHijri()
	{
		return hijri;
	}

	public String getSuggestionQuery()
	{
		return suggestionQuery;
	}

	public void setSuggestionQuery(String suggestionQuery)
	{
		this.suggestionQuery = suggestionQuery;
	}

	public Boolean getList()
	{
		return list;
	}

	public void setList(Boolean list)
	{
		this.list = list;
	}

	public Boolean getDoNotAutoShowList()
	{
		return doNotAutoShowList;
	}

	public void setDoNotAutoShowList(Boolean doNotAutoShowList)
	{
		this.doNotAutoShowList = doNotAutoShowList;
	}

	public Boolean getOnListOkRunAction()
	{
		return onListOkRunAction;
	}

	public void setOnListOkRunAction(Boolean onListOkRunAction)
	{
		this.onListOkRunAction = onListOkRunAction;
	}

	public String getFromParam()
	{
		return fromParam;
	}

	public void setFromParam(String fromParam)
	{
		this.fromParam = fromParam;
	}

	public String getFromParamMaxGapInDays()
	{
		return fromParamMaxGapInDays;
	}

	public void setFromParamMaxGapInDays(String fromParamMaxGapInDays)
	{
		this.fromParamMaxGapInDays = fromParamMaxGapInDays;
	}

	public String getRequiredGroup()
	{
		return requiredGroup;
	}

	public void setRequiredGroup(String requiredGroup)
	{
		this.requiredGroup = requiredGroup;
	}

	public Boolean getOnOkKeepSelectedItemsOnly()
	{
		return onOkKeepSelectedItemsOnly;
	}

	public void setOnOkKeepSelectedItemsOnly(Boolean onOkKeepSelectedItemsOnly)
	{
		this.onOkKeepSelectedItemsOnly = onOkKeepSelectedItemsOnly;
	}

	public CmnFieldFilteringParams getFieldFilteringParams()
	{
		return fieldFilteringParams;
	}

	public void setFieldFilteringParams(CmnFieldFilteringParams fieldFilteringParams)
	{
		this.fieldFilteringParams = fieldFilteringParams;
	}
}
