package com.namasoft.common.layout.list;

import com.namasoft.common.layout.TitledID;
import com.namasoft.common.layout.edit.NaMaText;
import com.namasoft.common.layout.metadata.BasicFieldMetaData;
import com.namasoft.common.utilities.ObjectChecker;

import jakarta.xml.bind.annotation.*;
import java.io.Serializable;
import java.util.*;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class ListScreenColumn implements Serializable, TitledID
{
	private NaMaText title;
	private String id;
	private String sourceColumn;
	private BasicFieldMetaData metaData;
	private String width;
	private boolean displayed = true;
	private SystemListColumnType columnType;
	private List<String> sources;
	private String arabicTemplate;
	private String englishTemplate;
	private String query;
	private Boolean required;
	private List<ReferenceSelectorColumnGoesTo> goesTo;

	public ListScreenColumn()
	{
		this(null, true);
	}

	public static ListScreenColumn hiden(String id)
	{
		return new ListScreenColumn(id, false);
	}

	public static ListScreenColumn displayed(String id)
	{
		return new ListScreenColumn(id, true);
	}

	private ListScreenColumn(String id, boolean displayed)
	{
		this.id = id;
		this.displayed = displayed;
	}

	@Override
	public NaMaText getTitle()
	{
		return title;
	}

	public void setTitle(NaMaText text)
	{
		this.title = text;
	}

	@Override
	public String getId()
	{
		return id;
	}

	public void setId(String id)
	{
		this.id = id;
	}

	public String getSourceColumn()
	{
		return sourceColumn;
	}

	public void setSourceColumn(String sourceColumn)
	{
		this.sourceColumn = sourceColumn;
	}

	public BasicFieldMetaData getMetaData()
	{
		return metaData;
	}

	public void setMetaData(BasicFieldMetaData metaData)
	{
		this.metaData = metaData;
	}

	public List<ReferenceSelectorColumnGoesTo> getGoesTo()
	{
		return goesTo;
	}

	public void setGoesTo(List<ReferenceSelectorColumnGoesTo> goesTo)
	{
		this.goesTo = goesTo;
	}

	public String calculateSourceColumn()
	{
		String sourceColumn = getSourceColumn();
		if (ObjectChecker.isEmptyOrNull(sourceColumn))
			sourceColumn = getId();
		return sourceColumn;
	}

	public boolean isDisplayed()
	{
		return displayed;
	}

	public void setDisplayed(boolean displayed)
	{
		this.displayed = displayed;
	}

	public String getWidth()
	{
		return width;
	}

	public void setWidth(String width)
	{
		this.width = width;
	}

	public SystemListColumnType getColumnType()
	{
		return columnType;
	}

	public void setColumnType(SystemListColumnType columnType)
	{
		this.columnType = columnType;
	}

	public List<String> getSources()
	{
		return sources;
	}

	public void setSources(List<String> sources)
	{
		this.sources = sources;
	}

	public String getArabicTemplate()
	{
		return arabicTemplate;
	}

	public void setArabicTemplate(String arabicTemplate)
	{
		this.arabicTemplate = arabicTemplate;
	}

	public String getEnglishTemplate()
	{
		return englishTemplate;
	}

	public void setEnglishTemplate(String englishTemplate)
	{
		this.englishTemplate = englishTemplate;
	}

	public ListScreenColumn sources(String... sources)
	{
		setSources(new ArrayList<>(Arrays.asList(sources)));
		return this;
	}

	public ListScreenColumn title(NaMaText resource)
	{
		setTitle(resource);
		return this;
	}

	public static List<ListScreenColumn> ofDisplayed(String... ids)
	{
		return of(true, ids);
	}

	public static List<ListScreenColumn> ofHidden(String... ids)
	{
		return of(false, ids);
	}

	private static List<ListScreenColumn> of(boolean displayed, String... ids)
	{
		ArrayList<ListScreenColumn> all = new ArrayList<>();
		for (String id : ids)
		{
			all.add(new ListScreenColumn(id, displayed));
		}
		return all;
	}

	public ListScreenColumn metadata(BasicFieldMetaData metaData)
	{
		setMetaData(metaData);
		return this;
	}

	public ListScreenColumn width(String width)
	{
		setWidth(width);
		return this;
	}

	public ListScreenColumn columnType(SystemListColumnType columnType)
	{
		setColumnType(columnType);
		return this;
	}

	public String getQuery()
	{
		return query;
	}

	public void setQuery(String query)
	{
		this.query = query;
	}

	public void setRequired(Boolean required)
	{
		this.required = required;
	}

	public Boolean getRequired()
	{
		return required;
	}

	public ReferenceSelectorColumnGoesTo goesTo(String srcField, String targetField)
	{
		ReferenceSelectorColumnGoesTo goesTo = new ReferenceSelectorColumnGoesTo();
		if (getGoesTo() == null)
			setGoesTo(new ArrayList<>());
		getGoesTo().add(goesTo);
		goesTo.setRefFieldId(srcField);
		goesTo.setTargetFieldId(targetField);
		return goesTo;
	}

	public ListScreenColumn required()
	{
		setRequired(true);
		return this;
	}
}
