package com.namasoft.common.layout.list;

import java.io.Serializable;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class ListScreenColumnStyler implements Serializable
{
	private String styleName;
	private String scriptName;

	public String getStyleName()
	{
		return styleName;
	}

	public void setStyleName(String formatName)
	{
		this.styleName = formatName;
	}

	public String getScriptName()
	{
		return scriptName;
	}

	public void setScriptName(String scriptName)
	{
		this.scriptName = scriptName;
	}

	public static ListScreenColumnStyler conditional(String scriptName)
	{
		ListScreenColumnStyler formatter = new ListScreenColumnStyler();
		formatter.setScriptName(scriptName);
		return formatter;
	}

	public static ListScreenColumnStyler normal(String formatName)
	{
		ListScreenColumnStyler formatter = new ListScreenColumnStyler();
		formatter.setStyleName(formatName);
		return formatter;
	}

}
