package com.namasoft.common.layout.list;

import com.namasoft.common.HasId;
import com.namasoft.common.fieldids.CommonFieldIds;
import com.namasoft.common.layout.edit.*;
import com.namasoft.common.utilities.*;
import jakarta.xml.bind.annotation.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
@SuppressWarnings("serial")
public class ListScreenLayout extends AbsListScreen
{
	private ListScreenLayout mobileScreen;
	private List<String> properties = new ArrayList<String>();
	private List<SortColumn> sortColumns = new ArrayList<SortColumn>();
	private List<String> actions = new ArrayList<String>();
	private boolean showSelectionColumn = true;
	private boolean allowOrdering = true;
	private boolean allQuestionsRequired = true;
	private boolean hideEntitySpecificFeatures = false;
	private NaMaText title;
	private List<ListViewActionPlaceHolder> moreActions;
	private Boolean alwaysShowTreeViewButton;
	private Boolean showTreeViewByDefault;
	private String listViewWidth;
	private List<GUIActionPlaceholder> listScreenToolbarActions;

	@XmlElementWrapper(name = "properties")
	@XmlElement(name = "property")
	public List<String> getProperties()
	{
		return properties;
	}

	@Override
	public List<String> fetchProperties()
	{
		return getProperties();
	}

	public void setProperties(List<String> properties)
	{
		this.properties = properties;
	}

	public ListScreenLayout sql(String sql)
	{
		setType(ListScreenType.Query);
		setQuery(new DTOListViewQuery());
		getQuery().setType(QueryTypes.SQL);
		getQuery().setQuery(sql);
		return this;
	}

	public ListScreenLayout oql(String oql)
	{
		return (ListScreenLayout) super.oql(oql);
	}

	public ListScreenLayout oql(String attribute, String questionFieldId)
	{
		String oqlQuery = "select " + getObjectName() + " from " + getOwner().getOwnerId() + " " + getObjectName() + " where " + getObjectName()
				+ "." + attribute + " = [" + questionFieldId + "] and [criteria]";
		return oql(oqlQuery);
	}

	@XmlElementWrapper(name = "sortColumns")
	@XmlElement(name = "column")
	public List<SortColumn> getSortColumns()
	{
		return sortColumns;
	}

	@Override
	public List<String> fetchSortColumnIds()
	{
		return getSortColumns() == null ? new ArrayList<>() : getSortColumns().stream().map(HasId::getId).collect(Collectors.toList());
	}

	public void setSortColumns(List<SortColumn> sortableColumns)
	{
		this.sortColumns = sortableColumns;
	}

	@XmlElementWrapper(name = "actions")
	@XmlElement(name = "action")
	public List<String> getActions()
	{
		return actions;
	}

	public List<ListViewActionPlaceHolder> getMoreActions()
	{
		return moreActions;
	}

	public void setMoreActions(List<ListViewActionPlaceHolder> moreActions)
	{
		this.moreActions = moreActions;
	}

	public void setActions(List<String> actions)
	{
		this.actions = actions;
	}

	public boolean isShowSelectionColumn()
	{
		return showSelectionColumn;
	}

	public void setShowSelectionColumn(boolean showSelectionColumn)
	{
		this.showSelectionColumn = showSelectionColumn;
	}

	public boolean isAllowOrdering()
	{
		return allowOrdering;
	}

	public void setAllowOrdering(boolean allowOrdering)
	{
		this.allowOrdering = allowOrdering;
	}

	public boolean isAllQuestionsRequired()
	{
		return allQuestionsRequired;
	}

	public void setAllQuestionsRequired(boolean allQuestionsRequired)
	{
		this.allQuestionsRequired = allQuestionsRequired;
	}

	public void moveDisplayColumnToLast(String id)
	{
		ListScreenColumn displayColumn = getDisplayColumn(id);
		if (displayColumn != null)
		{
			getDisplayColumns().remove(displayColumn);
			getDisplayColumns().add(displayColumn);
		}
	}

	public ListScreenLayout addDisplayedColumns(String... ids)
	{
		getDisplayColumns().addAll(ListScreenColumn.ofDisplayed(ids));
		return this;
	}

	public ListScreenLayout addDisplayedColumnsWithWidthes(String... idsAndWidthes)
	{
		if (idsAndWidthes.length % 2 != 0)
			throw new RuntimeException("idsAndWidthes must be even number");
		for (int i = 0; i < idsAndWidthes.length; i += 2)
		{
			getDisplayColumns().add(ListScreenColumn.displayed(idsAndWidthes[i]).width(idsAndWidthes[i + 1]));
		}
		return this;
	}

	public ListScreenLayout addHiddenColumnsWithWidthes(String... idsAndWidthes)
	{
		if (idsAndWidthes.length % 2 != 0)
			throw new RuntimeException("idsAndWidthes must be even number");
		for (int i = 0; i < idsAndWidthes.length; i += 2)
		{
			if (Character.isDigit(idsAndWidthes[i].charAt(0)))
				throw new RuntimeException("id " + idsAndWidthes[i] + " at " + i + " is width");
			getDisplayColumns().add(ListScreenColumn.hiden(idsAndWidthes[i]).width(idsAndWidthes[i + 1]));
		}
		return this;
	}

	public ListScreenLayout addHiddenRequiredColumn(String columnId)
	{
		getDisplayColumns().add(ListScreenColumn.hiden(columnId).required());
		return this;
	}

	public ListScreenLayout addHiddenColumns(String... ids)
	{
		getDisplayColumns().addAll(ListScreenColumn.ofHidden(ids));
		return this;
	}

	public ListScreenLayout addCriteriaFields(String... ids)
	{
		getCriteriaFields().addAll(CriteriaField.of(ids));
		return this;
	}

	public ListScreenLayout addSortColumns(String... ids)
	{
		getSortColumns().addAll(SortColumn.of(ids));
		return this;
	}

	public ListScreenLayout allowPaging()
	{
		setAllowPaging(true);
		return this;
	}

	public ListScreenLayout doNotAllowPaging()
	{
		setAllowPaging(false);
		return this;
	}

	public ListScreenLayout allowOrdering()
	{
		setAllowOrdering(true);
		return this;
	}

	public ListScreenLayout doNotAllowOrdering()
	{
		setAllowOrdering(false);
		return this;
	}

	public ListScreenLayout doNotAddDefaultSortColumns()
	{
		setAddDefaultSortColumns(false);
		return this;
	}

	public ListScreenLayout addDefaultSortColumns()
	{
		setAddDefaultSortColumns(true);
		return this;
	}

	public ListScreenLayout addQuestionField(QuestionField questionField)
	{
		getQuestionFields().add(questionField);
		return this;
	}

	public boolean isHideEntitySpecificFeatures()
	{
		return hideEntitySpecificFeatures;
	}

	public void setHideEntitySpecificFeatures(boolean hideEntitySpecificFeatures)
	{
		this.hideEntitySpecificFeatures = hideEntitySpecificFeatures;
	}

	public NaMaText getTitle()
	{
		return title;
	}

	public void setTitle(NaMaText title)
	{
		this.title = title;
	}

	public List<ListScreenColumn> visibleColumns()
	{
		return CollectionsUtility.filter(getDisplayColumns(), new Filter<ListScreenColumn>()
		{
			@Override
			public boolean include(ListScreenColumn object)
			{
				return object.isDisplayed();
			}
		});
	}

	public ListScreenLayout legalEntityId(String legalEntityId)
	{
		setLegalEntityId(legalEntityId);
		return this;
	}

	public ListScreenLayout departmentId(String departmentId)
	{
		setDepartmentId(departmentId);
		return this;
	}

	public ListScreenLayout sectorId(String sectorId)
	{
		setSectorId(sectorId);
		return this;
	}

	public ListScreenLayout analysisSetId(String analysisSetId)
	{
		setAnalysisSetId(analysisSetId);
		return this;
	}

	public ListScreenLayout branchId(String branchId)
	{
		setBranchId(branchId);
		return this;
	}

	public ListScreenLayout allQuestionsRequired()
	{
		setAllQuestionsRequired(true);
		return this;
	}

	public ListScreenLayout notAllQuestionsRequired()
	{
		setAllQuestionsRequired(false);
		return this;
	}

	public ListScreenLayout alwaysShowTreeViewButton()
	{
		setAlwaysShowTreeViewButton(true);
		return this;
	}

	public ListScreenLayout showTreeViewByDefault()
	{
		setShowTreeViewByDefault(true);
		return this;
	}

	public ListScreenLayout hideEntitySpecificFeatures()
	{
		setHideEntitySpecificFeatures(true);
		return this;
	}

	public ListScreenLayout title(String title)
	{
		setTitle(NaMaText.resource(title));
		return this;
	}

	public ListScreenLayout objectBased(Class<?> objectClass, String objectName)
	{
		return (ListScreenLayout) super.objectBased(objectClass,objectName);
	}

	public ListScreenLayout title(String arabic, String english)
	{
		setTitle(NaMaText.text(arabic, english));
		return this;
	}

	public ListScreenLayout selectable()
	{
		setSelectable(true);
		return this;
	}

	public ListScreenLayout notSelectable()
	{
		setSelectable(false);
		return this;
	}

	public ListScreenLayout doNotAddExtraCriteria()
	{
		setDoNotAddExtraCriteria(true);
		return this;
	}

	public ListScreenLayout crieriaPrefix(String crieriaPrefix)
	{
		setCrieriaPrefix(crieriaPrefix);
		return this;
	}
	public ListScreenLayout addMoreActions(String... actions)
	{
		if (moreActions == null)
			moreActions = new ArrayList<ListViewActionPlaceHolder>();
		for (String action : actions)
		{
			moreActions.add(ListViewActionPlaceHolder.create(action));
		}
		return this;
	}

	public Boolean getAlwaysShowTreeViewButton()
	{
		return alwaysShowTreeViewButton;
	}

	public void setAlwaysShowTreeViewButton(Boolean alwaysShowTreeViewButton)
	{
		this.alwaysShowTreeViewButton = alwaysShowTreeViewButton;
	}

	public Boolean getShowTreeViewByDefault()
	{
		return showTreeViewByDefault;
	}

	public void setShowTreeViewByDefault(Boolean showTreeViewByDefault)
	{
		this.showTreeViewByDefault = showTreeViewByDefault;
	}

	public String getListViewWidth()
	{
		return listViewWidth;
	}

	public void setListViewWidth(String listViewWidth)
	{
		this.listViewWidth = listViewWidth;
	}

	public void requiredColumns(String... columns)
	{
		for (String c : columns)
		{
			ListScreenColumn displayColumn = getDisplayColumn(c);
			if (displayColumn != null)
			{
				displayColumn.setRequired(true);
			}
		}
	}

	public ListScreenLayout dimensionsPrefix(String prefix)
	{
		return departmentId(prefix + "." + CommonFieldIds.DEPARTMENT).sectorId(prefix + "." + CommonFieldIds.SECTOR)
				.analysisSetId(prefix + "." + CommonFieldIds.ANALYSISSET).branchId(prefix + "." + CommonFieldIds.BRANCH)
				.legalEntityId(prefix + "." + CommonFieldIds.LEGAL_ENTITY);
	}

	@Override
	public void prefixEveryThing(String prefix, Function<ListScreenColumn, ListScreenColumn> cloner)
	{
		super.prefixEveryThing(prefix, cloner);
		for (int i = 0; i < getSortColumns().size(); i++)
		{
			getSortColumns().get(i).setId(prefix + "." + getSortColumns().get(i).getId());
		}
	}

	public ListScreenLayout getMobileScreen()
	{
		return mobileScreen;
	}

	public void setMobileScreen(ListScreenLayout mobileScreen)
	{
		this.mobileScreen = mobileScreen;
	}

	@Override
	public ListScreenLayout fetchMobileScreen()
	{
		return getMobileScreen();
	}

	public void removeFromColumnsAndSortAndCriteria(String... _ids)
	{
		List<String> ids = Arrays.asList(_ids);
		getDisplayColumns().removeIf(c -> ids.contains(c.getId()));
		getSortColumns().removeIf(c -> ids.contains(c.getId()));
		getCriteriaFields().removeIf(c -> ids.contains(c.getId()));
	}

	public ListScreenLayout configureForTimeline(ListScreenToTimelineConfig tlConfig)
	{
		setListToTimeline(tlConfig);
		return supportsTimeline();
	}

	public ListScreenLayout supportsTimeline()
	{
		setSupportsTimeline(true);
		setShowTimelineByDefault(true);
		return this;
	}

	public List<GUIActionPlaceholder> getListScreenToolbarActions()
	{
		return listScreenToolbarActions;
	}

	public void setListScreenToolbarActions(List<GUIActionPlaceholder> listScreenToolbarActions)
	{
		this.listScreenToolbarActions = listScreenToolbarActions;
	}

	public void addToolbarActions(String... actions)
	{
		if (getListScreenToolbarActions() == null)
			setListScreenToolbarActions(new ArrayList<>());
		for (String action : actions)
		{
			getListScreenToolbarActions().add(GUIActionPlaceholder.of(action));
		}
	}
}
