package com.namasoft.common.layout.list;

import java.io.Serializable;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class ListScript implements Serializable
{
	public enum ScriptType
	{
		imported, embedded
	}

	private ScriptType type;
	private String source;

	public ScriptType getType()
	{
		return type;
	}

	public void setType(ScriptType type)
	{
		this.type = type;
	}

	public String getSource()
	{
		return source;
	}

	public void setSource(String source)
	{
		this.source = source;
	}

	public static ListScript imported(String source)
	{
		ListScript listScript = new ListScript();
		listScript.setSource(source);
		listScript.setType(ScriptType.imported);
		return listScript;
	}

	public static ListScript embedded(String source)
	{
		ListScript listScript = new ListScript();
		listScript.setSource(source);
		listScript.setType(ScriptType.embedded);
		return listScript;
	}
}
