package com.namasoft.common.layout.list;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.layout.ActionPlaceholder;
import com.namasoft.common.layout.edit.CustomizedGUIActionInfo;
import com.namasoft.common.layout.edit.NaMaText;
import com.namasoft.common.utilities.ObjectChecker;

@XmlAccessorType(XmlAccessType.PROPERTY)
@SuppressWarnings("serial")
public class ListViewActionPlaceHolder extends NaMaDTO implements ActionPlaceholder
{
	private String id;
	private NaMaText title;
	private CustomizedGUIActionInfo customization;
	private String iconCode;

	public ListViewActionPlaceHolder()
	{
	}

	public String getId()
	{
		return id;
	}

	public void setId(String id)
	{
		this.id = id;
	}

	public NaMaText getTitle()
	{
		return title;
	}

	public void setTitle(NaMaText title)
	{
		this.title = title;
	}

	public static ListViewActionPlaceHolder create(String actionId)
	{
		ListViewActionPlaceHolder action = new ListViewActionPlaceHolder();
		action.setId(actionId);
		return action;
	}

	@Override
	public CustomizedGUIActionInfo getCustomization()
	{
		if (customization == null)
			customization = new CustomizedGUIActionInfo();
		return customization;
	}

	public void setCustomization(CustomizedGUIActionInfo customization)
	{
		this.customization = customization;
	}

	@Override
	public boolean shouldBeAdded()
	{
		return ObjectChecker.isNotEmptyOrNull(getId()) || ObjectChecker.isNotEmptyOrNull(getCustomization());
	}

	public String getIconCode()
	{
		return iconCode;
	}

	@Override
	public void setIconCode(String iconCode)
	{
		this.iconCode = iconCode;
	}
}
