package com.namasoft.common.layout.list;

import java.io.Serializable;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;

import com.namasoft.common.layout.edit.NaMaText;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class NaMaLink implements Serializable
{
	private LinkType type;
	private String entityType;
	private String id;
	private String code;
	private NaMaText title;
	private String url;

	public LinkType getType()
	{
		return type;
	}

	public void setType(LinkType type)
	{
		this.type = type;
	}

	public String getEntityType()
	{
		return entityType;
	}

	public void setEntityType(String entityType)
	{
		this.entityType = entityType;
	}

	public String getId()
	{
		return id;
	}

	public void setId(String id)
	{
		this.id = id;
	}

	public NaMaText getTitle()
	{
		return title;
	}

	public void setTitle(NaMaText title)
	{
		this.title = title;
	}

	public String getUrl()
	{
		return url;
	}

	public void setUrl(String url)
	{
		this.url = url;
	}

	public String getCode()
	{
		return code;
	}

	public void setCode(String code)
	{
		this.code = code;
	}

	protected NaMaLink()
	{
	}

	public static NaMaLink linkToMF(String entityType, String id, String code, String name1, String name2)
	{
		NaMaLink link = new NaMaLink();
		link.setEntityType(entityType);
		link.setId(id);
		link.setCode(code);
		link.setType(LinkType.Reference);
		link.setTitle(NaMaText.text(name1, name2));
		return link;
	}

	public static NaMaLink linkToRef(String entityType, String id, String code)
	{
		NaMaLink link = new NaMaLink();
		link.setEntityType(entityType);
		link.setId(id);
		link.setType(LinkType.Reference);
		link.setCode(code);
		return link;
	}

	public static NaMaLink link(String url, NaMaText title)
	{
		NaMaLink link = new NaMaLink();
		link.setType(LinkType.URL);
		link.setTitle(title);
		link.setUrl(url);
		return link;
	}
}
