package com.namasoft.common.layout.list;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;

import com.namasoft.common.layout.edit.NaMaText;
import com.namasoft.common.layout.metadata.FieldMetaData;

@XmlAccessorType(XmlAccessType.PROPERTY)
@SuppressWarnings("serial")
public class QuestionField extends FilterField
{
	private String sqlPart;
	private Boolean hidden;

	public QuestionField(String id, NaMaText title)
	{
		super(id, title);
	}

	public QuestionField()
	{
		super();
	}

	public QuestionField(String id)
	{
		this(id, null);
	}

	public String getSqlPart()
	{
		return sqlPart;
	}

	public void setSqlPart(String sqlPart)
	{
		this.sqlPart = sqlPart;
	}

	public static QuestionField create()
	{
		return new QuestionField();
	}

	public QuestionField id(String id)
	{
		setId(id);
		return this;
	}

	public QuestionField sqlPart(String setSqlPart)
	{
		setSqlPart(setSqlPart);
		return this;
	}

	public static QuestionField genericReference(String id, String... allowedEntities)
	{
		QuestionField questionField = new QuestionField(id);
		questionField.setMetaData(FieldMetaData.genericReference(id, allowedEntities));
		return questionField;
	}

	public QuestionField reference(String entityType)
	{
		setMetaData(FieldMetaData.reference(getId(), entityType));
		return this;
	}

	public Boolean getHidden()
	{
		return hidden;
	}

	public void setHidden(Boolean hidden)
	{
		this.hidden = hidden;
	}

}
