package com.namasoft.common.layout.list;

import com.namasoft.common.utilities.ObjectChecker;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import java.io.Serializable;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class ReferenceSelectorColumnGoesTo implements Serializable
{
	private String entityTypes;
	private String refFieldId;
	private String targetFieldId;

	public String getEntityTypes()
	{
		return entityTypes;
	}

	public void setEntityTypes(String entityTypes)
	{
		this.entityTypes = entityTypes;
	}

	public String getRefFieldId()
	{
		return refFieldId;
	}

	public void setRefFieldId(String refFieldId)
	{
		this.refFieldId = refFieldId;
	}

	public String getTargetFieldId()
	{
		return targetFieldId;
	}

	public void setTargetFieldId(String targetFieldId)
	{
		this.targetFieldId = targetFieldId;
	}

	public boolean matches(String currentOwnerType, String currentFieldId)
	{
		if (ObjectChecker.isNotEmptyOrNull(getEntityTypes()) && !getEntityTypes().contains("," + currentOwnerType + ","))
			return false;
		if (ObjectChecker.isNotEmptyOrNull(getRefFieldId()) && ObjectChecker.areNotEqual(getRefFieldId(), currentFieldId))
			return false;
		return true;
	}
}
