package com.namasoft.common.layout.list;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;

import com.namasoft.common.layout.TitledID;
import com.namasoft.common.layout.edit.NaMaText;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class SortColumn implements TitledID, Serializable
{
	public SortColumn(String id, NaMaText title)
	{
		setTitle(title);
		setId(id);
	}

	public SortColumn()
	{
	}

	public SortColumn(String id)
	{
		this(id, null);
	}

	private NaMaText title;
	private String id;

	@Override
	public NaMaText getTitle()
	{
		return title;
	}

	public void setTitle(NaMaText title)
	{
		this.title = title;
	}

	@Override
	public String getId()
	{
		return id;
	}

	public void setId(String id)
	{
		this.id = id;
	}

	public static List<SortColumn> of(String... ids)
	{
		List<SortColumn> columns = new ArrayList<SortColumn>();
		for (String id : ids)
		{
			columns.add(new SortColumn(id));
		}
		return columns;
	}

}
