package com.namasoft.common.layout.list.crosstab;

import java.util.ArrayList;
import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;

import com.namasoft.common.layout.TitledID;
import com.namasoft.common.layout.edit.EditScreenBlock;
import com.namasoft.common.layout.edit.NaMaText;
import com.namasoft.common.layout.list.ListScreenColumn;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
@SuppressWarnings("serial")
public class CrossTableBlock extends EditScreenBlock implements TitledID
{
	private List<ListScreenColumn> columns;
	private List<ListScreenColumn> rows;
	private List<ListScreenColumn> sums;
	private NaMaText title;

	@XmlElementWrapper(name = "rows")
	@XmlElement(name = "row")
	public List<ListScreenColumn> getRows()
	{
		return rows;
	}

	public void setRows(List<ListScreenColumn> rowIds)
	{
		this.rows = rowIds;
	}

	@XmlElementWrapper(name = "columns")
	@XmlElement(name = "column")
	public List<ListScreenColumn> getColumns()
	{
		return columns;
	}

	public void setColumns(List<ListScreenColumn> columnIds)
	{
		this.columns = columnIds;
	}

	@XmlElementWrapper(name = "sums")
	@XmlElement(name = "sum")
	public List<ListScreenColumn> getSums()
	{
		return sums;
	}

	public void setSums(List<ListScreenColumn> sumIds)
	{
		this.sums = sumIds;
	}

	public CrossTableBlock addColumnIds(String... columnIds)
	{
		List<ListScreenColumn> columns = ListScreenColumn.ofDisplayed(columnIds);
		return addColumns(columns);
	}

	public CrossTableBlock addColumns(List<ListScreenColumn> columns)
	{
		if (getColumns() == null)
			setColumns(new ArrayList<ListScreenColumn>());
		getColumns().addAll(columns);
		return this;
	}

	public CrossTableBlock addRowIds(String... rowIds)
	{
		return addRows(ListScreenColumn.ofDisplayed(rowIds));
	}

	public CrossTableBlock addRows(List<ListScreenColumn> rows)
	{
		if (getRows() == null)
			setRows(new ArrayList<ListScreenColumn>());
		getRows().addAll(rows);
		return this;
	}

	public CrossTableBlock addSumColumnIds(String... sumColumnsIds)
	{
		List<ListScreenColumn> sumColumns = ListScreenColumn.ofDisplayed(sumColumnsIds);
		return addSumColumns(sumColumns);
	}

	public CrossTableBlock addSumColumns(List<ListScreenColumn> sumColumns)
	{
		if (getSums() == null)
			setSums(new ArrayList<ListScreenColumn>());
		getSums().addAll(sumColumns);
		return this;
	}

	public CrossTableBlock field(String fieldId)
	{
		setFieldId(fieldId);
		return this;
	}

	public NaMaText getTitle()
	{
		return title;
	}

	public void setTitle(NaMaText title)
	{
		this.title = title;
	}

	@Override
	@XmlTransient
	public String getId()
	{
		return getFieldId();
	}
}
