package com.namasoft.common.layout.metadata;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.constants.GridAction;
import com.namasoft.common.utilities.ObjectChecker;
import jakarta.xml.bind.annotation.*;

import java.util.*;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class CmnGUIPostAction extends NaMaDTO
{
	private String fieldID;
	private Boolean forInsertLine;
	private Boolean forDeleteLine;
	private List<String> contextFields;

	public String getFieldID()
	{
		return fieldID;
	}

	public void setFieldID(String fieldID)
	{
		this.fieldID = fieldID;
	}

	public Boolean getForInsertLine()
	{
		return forInsertLine;
	}

	public void setForInsertLine(Boolean forInsertLine)
	{
		this.forInsertLine = forInsertLine;
	}

	public Boolean getForDeleteLine()
	{
		return forDeleteLine;
	}

	public void setForDeleteLine(Boolean forDeleteLine)
	{
		this.forDeleteLine = forDeleteLine;
	}

	public List<String> getContextFields()
	{
		if (contextFields == null)
			contextFields = new ArrayList<>();
		return contextFields;
	}

	public void setContextFields(List<String> contextFields)
	{
		this.contextFields = contextFields;
	}

	public void mergeWith(CmnGUIPostAction o)
	{
		if (o == this || o == null)
			return;
		setForDeleteLine(ObjectChecker.isAnyTrue(getForDeleteLine(), o.getForDeleteLine()));
		setForDeleteLine(ObjectChecker.isAnyTrue(getForInsertLine(), o.getForInsertLine()));
		for (String f : o.getContextFields())
			if (!getContextFields().contains(f))
				getContextFields().add(f);
	}

	public boolean doesNotMatchGridAction(GridAction gridAction)
	{
		return !matchesGridAction(gridAction);
	}

	public boolean matchesGridAction(GridAction gridAction)
	{
		if (gridAction == null && ObjectChecker.areAllFalseOrNull(getForInsertLine(), getForDeleteLine()))
			return true;
		if (gridAction == GridAction.DeleteLine && ObjectChecker.isTrue(getForDeleteLine()))
			return true;
		if (gridAction == GridAction.InsertLine && ObjectChecker.isTrue(getForInsertLine()))
			return true;
		return false;
	}
}
