package com.namasoft.common.layout.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.utilities.ObjectChecker;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class CustomReportsMetadata extends NaMaDTO
{
	private List<CustomRepInfo> customReports = new ArrayList<CustomRepInfo>();
	private HashMap<String, IndexList> indices = new HashMap<String, IndexList>();

	public List<CustomRepInfo> getCustomReports()
	{
		return customReports;
	}

	public void setCustomReports(List<CustomRepInfo> customReports)
	{
		this.customReports = customReports;
	}

	public HashMap<String, IndexList> getIndices()
	{
		return indices;
	}

	public void setIndices(HashMap<String, IndexList> indices)
	{
		this.indices = indices;
	}

	public List<CustomRepInfo> getEntityCustomReports(String entityType)
	{
		List<CustomRepInfo> list = new ArrayList<CustomRepInfo>();
		IndexList indexList = indices.get(entityType);
		if (ObjectChecker.isNotEmptyOrNull(indexList))
		{
			for (Integer index : indexList.getIndices())
			{
				list.add(customReports.get(index));
			}
		}
		return list;
	}
}
