package com.namasoft.common.layout.metadata;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.flatobjects.KeyList;
import com.namasoft.common.utilities.*;
import jakarta.xml.bind.annotation.*;

import java.util.*;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class CustomizedFieldsInfo extends NaMaDTO
{
	private Map<String, String> icons;
	private Map<String, ThemeColor> colors;
	private HashMap<String, String> entityFieldMasks;
	private HashMap<String, String> genericFieldMasks;
	private HashMap<String, String> g2EntityFieldMasks;
	private HashMap<String, String> g2GenericFieldMasks;
	private Map<String, ESignatureInfo> entitySignatureFields;
	private Map<String, UseScannerInFieldInfo> useScannerInFields;
	private Map<String, ESignatureInfo> genericSignatureFields;
	private List<String> entityRichTextFields;
	private List<String> genericRichTextFields;
	private List<String> notColorFields;
	private Map<String, String> fieldFiltersMap;
	private Map<String, FieldStyle> entityFieldStyleMap;
	private Map<String, FieldStyle> genericFieldStyleMap;
	private Map<String, String> genericOpenCreateFields;
	private List<String> genericDisabledFields;
	private List<String> entityDisabledFields;
	private Map<String, String> entityOpenCreateFields;
	private List<KeyList> emailSendToTypes;
	private List<String> textToLinks;
	private List<String> textToPhones;
	private List<String> textToEmails;
	private List<String> entityOpenInPopup;
	private List<String> genericOpenInPopup;

	public static List<CmnExtraReferenceSearchSetting> calcExtraReferenceSearchSettings(String entityType, boolean isMaster,
			Map<String, CmnExtraReferenceSearchSettingList> info)
	{
		if (ObjectChecker.isEmptyOrNull(entityType) || ObjectChecker.isEmptyOrNull(info))
			return new ArrayList<>();
		CmnExtraReferenceSearchSettingList settings = info.get(entityType);
		CmnExtraReferenceSearchSettingList allScreens = info.get("AllScreens");
		CmnExtraReferenceSearchSettingList documentOrMaster = info.get(isMaster ? "MasterFiles" : "Documents");
		if (ObjectChecker.areAllEmptyOrNull(settings, allScreens, documentOrMaster))
			return new ArrayList<>();
		return CollectionsUtility.join(settings == null ? null : settings.getList(), documentOrMaster == null ? null : documentOrMaster.getList(),
				allScreens == null ? null : allScreens.getList());
	}

	public List<String> getEntityOpenInPopup()
	{
		if (entityOpenInPopup == null)
			entityOpenInPopup = new ArrayList<>();
		return entityOpenInPopup;
	}

	public void setEntityOpenInPopup(List<String> entityOpenInPopup)
	{
		this.entityOpenInPopup = entityOpenInPopup;
	}

	public List<String> getGenericOpenInPopup()
	{
		if (genericOpenInPopup == null)
			genericOpenInPopup = new ArrayList<>();
		return genericOpenInPopup;
	}

	public void setGenericOpenInPopup(List<String> genericOpenInPopup)
	{
		this.genericOpenInPopup = genericOpenInPopup;
	}

	public List<String> getTextToLinks()
	{
		if (textToLinks == null)
			textToLinks = new ArrayList<>();
		return textToLinks;
	}

	public void setTextToLinks(List<String> textToLinks)
	{
		this.textToLinks = textToLinks;
	}

	public List<String> getTextToPhones()
	{
		if (textToPhones == null)
			textToPhones = new ArrayList<>();
		return textToPhones;
	}

	public void setTextToPhones(List<String> textToPhones)
	{
		this.textToPhones = textToPhones;
	}

	public List<String> getTextToEmails()
	{
		if (textToEmails == null)
			textToEmails = new ArrayList<>();
		return textToEmails;
	}

	public void setTextToEmails(List<String> textToEmails)
	{
		this.textToEmails = textToEmails;
	}

	public void setNotColorFields(List<String> notColorFields)
	{
		this.notColorFields = notColorFields;
	}

	public List<String> getNotColorFields()
	{
		if (notColorFields == null)
			notColorFields = new ArrayList<>();
		return notColorFields;
	}

	public Map<String, String> getGenericOpenCreateFields()
	{
		if (genericOpenCreateFields == null)
			genericOpenCreateFields = new HashMap<>();
		return genericOpenCreateFields;
	}

	public List<String> getGenericDisabledFields()
	{
		if (genericDisabledFields == null)
			genericDisabledFields = new ArrayList<>();
		return genericDisabledFields;
	}

	public void setGenericDisabledFields(List<String> genericDisabledFields)
	{
		this.genericDisabledFields = genericDisabledFields;
	}

	public void setGenericOpenCreateFields(Map<String, String> genericOpenCreateFields)
	{
		this.genericOpenCreateFields = genericOpenCreateFields;
	}

	public HashMap<String, String> getG2EntityFieldMasks()
	{
		if (g2EntityFieldMasks == null)
			g2EntityFieldMasks = new HashMap<>();
		return g2EntityFieldMasks;
	}

	public void setG2EntityFieldMasks(HashMap<String, String> g2EntityFieldMasks)
	{
		this.g2EntityFieldMasks = g2EntityFieldMasks;
	}

	public HashMap<String, String> getG2GenericFieldMasks()
	{
		if (g2GenericFieldMasks == null)
			g2GenericFieldMasks = new HashMap<>();
		return g2GenericFieldMasks;
	}

	public void setG2GenericFieldMasks(HashMap<String, String> g2GenericFieldMasks)
	{
		this.g2GenericFieldMasks = g2GenericFieldMasks;
	}

	public HashMap<String, String> getEntityFieldMasks()
	{
		if (entityFieldMasks == null)
			entityFieldMasks = new HashMap<>();
		return entityFieldMasks;
	}

	public void setEntityFieldMasks(HashMap<String, String> entityFieldMasks)
	{
		this.entityFieldMasks = entityFieldMasks;
	}

	public HashMap<String, String> getGenericFieldMasks()
	{
		if (genericFieldMasks == null)
			genericFieldMasks = new HashMap<>();
		return genericFieldMasks;
	}

	public void setGenericFieldMasks(HashMap<String, String> genericFieldMasks)
	{
		this.genericFieldMasks = genericFieldMasks;
	}

	public String getFieldDisplayMask(String entityType, String fieldId)
	{
		String mask = recursivelyFindMask(entityType, fieldId, getEntityFieldMasks());
		if (mask != null)
			return mask;
		return recursivelyFindMask(null, fieldId, getGenericFieldMasks());
	}

	private String recursivelyFindMask(String entityType, String fieldId, HashMap<String, String> map)
	{
		String searchId = ObjectChecker.isEmptyOrNull(entityType) ? fieldId : entityType + "." + fieldId;
		String mask = map.get(searchId);
		if (mask != null)
			return mask;
		if (ObjectChecker.areEqual(fieldId, "*"))
			return null;
		if (fieldId.endsWith(".*"))
			fieldId = fieldId.substring(0, fieldId.length() - 2);
		if (fieldId.contains("."))
			fieldId = StringUtils.substringBeforeLast(fieldId, ".") + ".*";
		else
			fieldId = "*";
		return recursivelyFindMask(entityType, fieldId, map);
	}

	public FieldStyle getFieldStyle(String entityType, String fieldId)
	{
		FieldStyle style = getEntityFieldStyleMap().get(entityType + "." + fieldId);
		if (style != null)
			return style;
		style = getGenericFieldStyleMap().get(fieldId);
		return style;
	}

	public boolean isSignatureField(String entityType, String fieldId)
	{
		if (getEntitySignatureFields().containsKey(entityType + "." + fieldId))
			return true;
		return getGenericSignatureFields().containsKey(fieldId);
	}

	public boolean isRichTextField(String entityType, String fieldId)
	{
		if (Collections.binarySearch(getEntityRichTextFields(), entityType + "." + fieldId) >= 0)
			return true;
		return Collections.binarySearch(getGenericRichTextFields(), fieldId) >= 0;
	}

	public boolean isDisabledField(String entityType, String fieldId)
	{
		if (Collections.binarySearch(getEntityDisabledFields(), entityType + "." + fieldId) >= 0)
			return true;
		return Collections.binarySearch(getGenericDisabledFields(), fieldId) >= 0;
	}

	public boolean isOpenCreate(String entityType, String fieldId)
	{
		if (getEntityOpenCreateFields().containsKey(entityType + "." + fieldId))
			return true;
		if (getGenericOpenCreateFields().containsKey(fieldId))
			return true;
		if (getEntityOpenCreateFields().containsKey(entityType + ".*"))
			return true;
		return getGenericOpenCreateFields().containsKey("*");
	}

	public String fetchOpenCreateField(String entityType, String fieldId)
	{
		String field = getEntityOpenCreateFields().get(entityType + "." + fieldId);
		if (ObjectChecker.isNotEmptyOrNull(field))
			return field;
		field = getGenericOpenCreateFields().get(fieldId);
		if (ObjectChecker.isNotEmptyOrNull(field))
			return field;
		field = getEntityOpenCreateFields().get(entityType + ".*");
		if (ObjectChecker.isNotEmptyOrNull(field))
			return field;
		field = getGenericOpenCreateFields().get("*");
		if (ObjectChecker.isNotEmptyOrNull(field))
			return field;
		return null;
	}

	public boolean isOpenInPopup(String entityType, String fieldId)
	{
		if (Collections.binarySearch(getEntityOpenInPopup(), entityType + "." + fieldId) >= 0)
			return true;
		if (Collections.binarySearch(getGenericOpenInPopup(), fieldId) >= 0)
			return true;
		if (Collections.binarySearch(getEntityOpenInPopup(), entityType + ".*") >= 0)
			return true;
		return Collections.binarySearch(getGenericOpenInPopup(), "*") >= 0;
	}

	public Map<String, ESignatureInfo> getEntitySignatureFields()
	{
		if (entitySignatureFields == null)
			entitySignatureFields = new HashMap<>();
		return entitySignatureFields;
	}

	public void setEntitySignatureFields(Map<String, ESignatureInfo> entitySignatureFields)
	{
		this.entitySignatureFields = entitySignatureFields;
	}

	public Map<String, ESignatureInfo> getGenericSignatureFields()
	{
		if (genericSignatureFields == null)
			genericSignatureFields = new HashMap<>();
		return genericSignatureFields;
	}

	public void setGenericSignatureFields(Map<String, ESignatureInfo> genericSignatureFields)
	{
		this.genericSignatureFields = genericSignatureFields;
	}

	public List<String> getEntityRichTextFields()
	{
		if (entityRichTextFields == null)
			entityRichTextFields = new ArrayList<>();
		return entityRichTextFields;
	}

	public void setEntityRichTextFields(List<String> entityRichTextFields)
	{
		this.entityRichTextFields = entityRichTextFields;
	}

	public List<String> getGenericRichTextFields()
	{
		if (genericRichTextFields == null)
			genericRichTextFields = new ArrayList<>();
		return genericRichTextFields;
	}

	public void setGenericRichTextFields(List<String> genericRichTextFields)
	{
		this.genericRichTextFields = genericRichTextFields;
	}

	public Map<String, String> getFieldFiltersMap()
	{
		if (fieldFiltersMap == null)
			fieldFiltersMap = new HashMap<>();
		return fieldFiltersMap;
	}

	public void setFieldFiltersMap(Map<String, String> fieldFiltersMap)
	{
		this.fieldFiltersMap = fieldFiltersMap;
	}

	public List<String> getEntityDisabledFields()
	{
		if (entityDisabledFields == null)
			entityDisabledFields = new ArrayList<>();
		return entityDisabledFields;
	}

	public Map<String, String> getEntityOpenCreateFields()
	{
		if (entityOpenCreateFields == null)
			entityOpenCreateFields = new HashMap<>();
		return entityOpenCreateFields;
	}

	public void setEntityDisabledFields(List<String> entityDisabledFields)
	{
		this.entityDisabledFields = entityDisabledFields;
	}

	public void setEntityOpenCreateFields(Map<String, String> entityOpenCreateFields)
	{
		this.entityOpenCreateFields = entityOpenCreateFields;
	}

	public Map<String, FieldStyle> getEntityFieldStyleMap()
	{
		if (entityFieldStyleMap == null)
			entityFieldStyleMap = new HashMap<>();
		return entityFieldStyleMap;
	}

	public void setEntityFieldStyleMap(Map<String, FieldStyle> entityFieldStyleMap)
	{
		this.entityFieldStyleMap = entityFieldStyleMap;
	}

	public Map<String, FieldStyle> getGenericFieldStyleMap()
	{
		if (genericFieldStyleMap == null)
			genericFieldStyleMap = new HashMap<>();
		return genericFieldStyleMap;
	}

	public void setGenericFieldStyleMap(Map<String, FieldStyle> genericFieldStyleMap)
	{
		this.genericFieldStyleMap = genericFieldStyleMap;
	}

	public Map<String, String> getIcons()
	{
		return icons;
	}

	public void setIcons(Map<String, String> icons)
	{
		this.icons = icons;
	}

	public Map<String, ThemeColor> getColors()
	{
		return colors;
	}

	public void setColors(Map<String, ThemeColor> colors)
	{
		this.colors = colors;
	}

	public List<KeyList> getEmailSendToTypes()
	{
		if (emailSendToTypes == null)
			emailSendToTypes = new ArrayList<>();
		return emailSendToTypes;
	}

	public void setEmailSendToTypes(List<KeyList> emailSendToTypes)
	{
		this.emailSendToTypes = emailSendToTypes;
	}

	public Map<String, UseScannerInFieldInfo> getUseScannerInFields()
	{
		if (useScannerInFields == null)
			useScannerInFields = new HashMap<>();
		return useScannerInFields;
	}

	public void setUseScannerInFields(Map<String, UseScannerInFieldInfo> useScannerInFields)
	{
		this.useScannerInFields = useScannerInFields;
	}


}