package com.namasoft.common.layout.metadata;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.utilities.ObjectChecker;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class DTOCMNKeyboardShortcut extends NaMaDTO implements IDTOKeyboardShortcut
{
	private Boolean useAlt;
	private Boolean useCtrl;
	private Boolean useShift;
	private String theKey;

	@Override
	public Boolean getUseAlt()
	{
		return useAlt;
	}

	@Override
	public Boolean getUseCtrl()
	{
		return useCtrl;
	}

	@Override
	public Boolean getUseShift()
	{
		return useShift;
	}

	@Override
	public String getTheKey()
	{
		return theKey;
	}

	public void setTheKey(String theKey)
	{
		this.theKey = theKey;
	}

	public void setUseAlt(Boolean useAlt)
	{
		this.useAlt = useAlt;
	}

	public void setUseCtrl(Boolean useCtrl)
	{
		this.useCtrl = useCtrl;
	}

	public void setUseShift(Boolean useShift)
	{
		this.useShift = useShift;
	}

	@Override
	public boolean isEmpty()
	{
		return ObjectChecker.isEmptyOrNull(getTheKey());
	}
}
