package com.namasoft.common.layout.metadata;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.utilities.ObjectChecker;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class EntityFieldPair extends NaMaDTO
{
	private String entityType;
	private String fieldId;

	public String getEntityType()
	{
		if (entityType == null)
			entityType = "";
		return entityType;
	}

	public void setEntityType(String entityType)
	{
		this.entityType = entityType;
	}

	public String getFieldId()
	{
		if (fieldId == null)
			fieldId = "";
		return fieldId;
	}

	public void setFieldId(String fieldId)
	{
		this.fieldId = fieldId;
	}

	@Override
	public boolean equals(Object obj)
	{
		if (obj instanceof EntityFieldPair)
		{
			return ObjectChecker.arePairsEqual(getEntityType(), ((EntityFieldPair) obj).getEntityType(), getFieldId(),
					((EntityFieldPair) obj).getFieldId());
		}
		return super.equals(obj);
	}

	@Override
	public int hashCode()
	{
		return getFieldId().hashCode() + getEntityType().hashCode();
	}

	public static EntityFieldPair of(String entityType, String field)
	{
		EntityFieldPair pair = new EntityFieldPair();
		pair.setEntityType(entityType);
		pair.setFieldId(field);
		return pair;
	}

	@Override
	public String toString()
	{
		return getEntityType() + "#" + getFieldId();
	}
}
