package com.namasoft.common.layout.metadata;

import java.io.Serializable;
import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class EntityTypeMetaData implements Serializable
{
	private String entityType;
	private FieldMetaData codeMetaData;
	private String serviceName;
	private String moduleId;
	private String serviceClassName;
	private String theDTOKlassName;
	private Boolean isDocument;
	private Boolean isSimpleEntity;
	private Boolean withAltCode;
	private String relatedToFeature;
	private List<ApprovalRuleMetadata> applicableApprovalRules;

	public EntityTypeMetaData()
	{

	}

	public EntityTypeMetaData(String entityType, FieldMetaData codeMetaData, String serviceName, String serviceClassName, Boolean isDocument,
			Boolean isSImpleENtity, String relatedToFeature, List<ApprovalRuleMetadata> applicableApprovalRules, Class dtoClass, Boolean withAltCode)
	{
		this.codeMetaData = codeMetaData;
		this.entityType = entityType;
		this.serviceName = serviceName;
		this.serviceClassName = serviceClassName;
		this.isDocument = isDocument;
		this.relatedToFeature = relatedToFeature;
		this.applicableApprovalRules = applicableApprovalRules;
		if (dtoClass != null)
			this.theDTOKlassName = dtoClass.getName();
		this.withAltCode = withAltCode;
	}

	public String getEntityType()
	{
		return entityType;
	}

	public void setEntityType(String entityType)
	{
		this.entityType = entityType;
	}

	public FieldMetaData getCodeMetaData()
	{
		return codeMetaData;
	}

	public void setCodeMetaData(FieldMetaData codeMetaData)
	{
		this.codeMetaData = codeMetaData;
	}

	public String getServiceName()
	{
		return serviceName;
	}

	public void setServiceName(String serviceName)
	{
		this.serviceName = serviceName;
	}

	public String getModuleId()
	{
		return moduleId;
	}

	public void setModuleId(String moduleId)
	{
		this.moduleId = moduleId;
	}

	public String getServiceClassName()
	{
		return serviceClassName;
	}

	public void setServiceClassName(String serviceClassName)
	{
		this.serviceClassName = serviceClassName;
	}

	public Boolean getIsDocument()
	{
		return isDocument;
	}

	public void setIsDocument(Boolean isDocument)
	{
		this.isDocument = isDocument;
	}

	public Boolean getIsSimpleEntity()
	{
		return isSimpleEntity;
	}

	public void setIsSimpleEntity(Boolean isSimpleEntity)
	{
		this.isSimpleEntity = isSimpleEntity;
	}

	public String getRelatedToFeature()
	{
		return relatedToFeature;
	}

	public void setRelatedToFeature(String relatedTofeature)
	{
		this.relatedToFeature = relatedTofeature;
	}

	public List<ApprovalRuleMetadata> getApplicableApprovalRules()
	{
		return applicableApprovalRules;
	}

	public void setApplicableApprovalRules(List<ApprovalRuleMetadata> applicableApprovalRules)
	{
		this.applicableApprovalRules = applicableApprovalRules;
	}

	public String getTheDTOKlassName()
	{
		return theDTOKlassName;
	}

	public void setTheDTOKlassName(String theDTOKlassName)
	{
		this.theDTOKlassName = theDTOKlassName;
	}

	public Boolean getWithAltCode()
	{
		return withAltCode;
	}

	public void setWithAltCode(Boolean withAltCode)
	{
		this.withAltCode = withAltCode;
	}
}
