package com.namasoft.common.layout.metadata;

import java.util.ArrayList;
import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.ObjectChecker;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class FieldAllowedValueInfo extends NaMaDTO
{
	private Boolean restrict = false;
	private List<String> allowedValues = new ArrayList<>();

	public Boolean getRestrict()
	{
		return restrict;
	}

	public void setRestrict(Boolean restrict)
	{
		this.restrict = restrict;
	}

	public List<String> getAllowedValues()
	{
		return allowedValues;
	}

	public void setAllowedValues(List<String> allowedValues)
	{
		this.allowedValues = allowedValues;
	}

	public void addValues(String... values)
	{
		for (String value : values)
		{
			if (ObjectChecker.isNotEmptyOrNull(value))
				allowedValues.add(value);
		}
		CollectionsUtility.sortAndRemoveDuplicates(allowedValues);
	}

}
