package com.namasoft.common.layout.metadata;

import com.namasoft.common.constants.GridAction;
import com.namasoft.common.utilities.ObjectChecker;

import java.io.Serializable;
import java.util.*;

@SuppressWarnings("serial")
public class FieldInformation implements Serializable
{
	private String fieldId;
	private boolean needsValidation = false;
	private boolean hasPostAction = false;
	private boolean hasGridAction = false;
	private boolean hasSuggestionProvider = false;
	private boolean hasPreValidation = false;
	private boolean hasSearchContext = false;
	private boolean hasQuickCreator = false;
	private List<String> validationContextFields = new ArrayList<>();
	private List<String> postActionContextFields = new ArrayList<>();
	private List<String> sumsFields = new ArrayList<>();
	private List<String> gridActionContextFields = new ArrayList<>();
	private List<String> suggestionProviderContextFields = new ArrayList<>();
	private List<GridAction> gridActions = new ArrayList<>();
	private List<String> preValidationContextFields = new ArrayList<>();
	private List<String> prevalidatFields = new ArrayList<>();
	private List<String> searchContextFields = new ArrayList<>();
	private Set<String> dynamicSearchContextFields = new HashSet<>();
	private List<String> quickCreatorFields = new ArrayList<>();
	private int validationLevel;
	private String gridValidationField;
	public FieldInformation()
	{
	}

	public FieldInformation(String fieldId)
	{
		setFieldId(fieldId);
	}

	public String getFieldId()
	{
		return fieldId;
	}

	public void setFieldId(String fieldId)
	{
		this.fieldId = fieldId;
	}

	public List<String> getValidationContextFields()
	{
		return validationContextFields;
	}

	public boolean isNeedsValidation()
	{
		return needsValidation;
	}

	public void setNeedsValidation(boolean needsValidation)
	{
		this.needsValidation = needsValidation;
	}

	public boolean hasPostAction()
	{
		return hasPostAction;
	}

	public void setHasPostAction(boolean needsPostAction)
	{
		this.hasPostAction = needsPostAction;
	}

	public List<String> getPostActionContextFields()
	{
		return postActionContextFields;
	}

	public void setPostActionContextFields(List<String> postActionContextFields)
	{
		this.postActionContextFields = postActionContextFields;
	}

	public void addPostActionContextFields(String... args)
	{
		getPostActionContextFields().addAll(Arrays.asList(args));
	}

	public void addSumsFields(String... args)
	{
		getSumsFields().addAll(Arrays.asList(args));
	}

	public void addGridActions(GridAction... actions)
	{
		getGridActions().addAll(Arrays.asList(actions));
	}

	public void addGridActionContextFields(String... contextFields)
	{
		getGridActionContextFields().addAll(Arrays.asList(contextFields));
	}

	public void addSuggestionProviderContextFields(String... contextFields)
	{
		getSuggestionProviderContextFields().addAll(Arrays.asList(contextFields));
	}

	public void addSearcherActionContextFields(String... args)
	{
		getSearchContextFields().addAll(Arrays.asList(args));
	}

	public void addQuickCreatorFieldsContextFields(String... args)
	{
		getQuickCreatorFields().addAll(Arrays.asList(args));
	}

	public List<String> getPrevalidatFields()
	{
		return prevalidatFields;
	}

	public void setPrevalidatFields(List<String> prevalidatFields)
	{
		this.prevalidatFields = prevalidatFields;
	}

	public void addPrevalidatFields(String... prevalidatFields)
	{
		getPrevalidatFields().addAll(Arrays.asList(prevalidatFields));
	}

	public void setValidationContextFields(List<String> validationContextFields)
	{
		this.validationContextFields = validationContextFields;
	}

	public void addValidationContextFields(String... validationContextFields)
	{
		getValidationContextFields().addAll(Arrays.asList(validationContextFields));
	}

	public FieldInformation needsValidation()
	{
		setNeedsValidation(true);
		return this;
	}

	public FieldInformation needsPostAction()
	{
		setHasPostAction(true);
		return this;
	}

	public FieldInformation withPostContext(String... postContext)
	{
		addPostActionContextFields(postContext);
		return this;
	}

	public FieldInformation withValidationContext(String... validationContext)
	{
		addValidationContextFields(validationContext);
		return this;
	}

	public FieldInformation shouldPrevalidate(String... relatedPrevalidateFields)
	{
		addPrevalidatFields(relatedPrevalidateFields);
		return this;
	}

	public List<String> getPreValidationContextFields()
	{
		return preValidationContextFields;
	}

	public void addPreValidationContextFields(String... args)
	{
		getPreValidationContextFields().addAll(Arrays.asList(args));
	}

	public boolean hasPreAction()
	{
		return hasPreValidation;
	}

	public void setHasPreValidation(boolean needsPreAction)
	{
		this.hasPreValidation = needsPreAction;
	}

	public void setPreValidationContextFields(List<String> preValidationContextFields)
	{
		this.preValidationContextFields = preValidationContextFields;
	}

	public boolean shouldPrevalidateOtherFields()
	{
		return ObjectChecker.isNotEmptyOrNull(getPrevalidatFields());
	}

	public boolean hasPostActions()
	{
		return shouldPrevalidateOtherFields() || hasPostAction() || isNeedsValidation();
	}

	public List<String> getSearchContextFields()
	{
		return searchContextFields;
	}

	public void setSearchContextFields(List<String> searchContextFields)
	{
		this.searchContextFields = searchContextFields;
	}

	public List<String> getQuickCreatorFields()
	{
		return quickCreatorFields;
	}

	public void setQuickCreatorFields(List<String> quickCreatorFields)
	{
		this.quickCreatorFields = quickCreatorFields;
	}

	public boolean hasSearchContext()
	{
		return hasSearchContext;
	}

	public void setHasSearchContext(boolean hasSearchContext)
	{
		this.hasSearchContext = hasSearchContext;
	}

	public boolean hasQuickCreator()
	{
		return hasQuickCreator;
	}

	public void setHasQuickCreator(boolean hasQuickCreator)
	{
		this.hasQuickCreator = hasQuickCreator;
	}

	public boolean isHasGridAction()
	{
		return hasGridAction;
	}

	public void setHasGridAction(boolean hasGridAction)
	{
		this.hasGridAction = hasGridAction;
	}

	public List<String> getGridActionContextFields()
	{
		return gridActionContextFields;
	}

	public void setGridActionContextFields(List<String> gridActionContextFields)
	{
		this.gridActionContextFields = gridActionContextFields;
	}

	public List<GridAction> getGridActions()
	{
		return gridActions;
	}

	public void setGridActions(List<GridAction> gridActions)
	{
		this.gridActions = gridActions;
	}

	public boolean isHasSuggestionProvider()
	{
		return hasSuggestionProvider;
	}

	public void setHasSuggestionProvider(boolean hasSuggestionProvider)
	{
		this.hasSuggestionProvider = hasSuggestionProvider;
	}

	public List<String> getSuggestionProviderContextFields()
	{
		return suggestionProviderContextFields;
	}

	public void setSuggestionProviderContextFields(List<String> suggestionProviderContextFields)
	{
		this.suggestionProviderContextFields = suggestionProviderContextFields;
	}

	public List<String> getSumsFields()
	{
		return sumsFields;
	}

	public void setSumsFields(List<String> sumsFields)
	{
		this.sumsFields = sumsFields;
	}

	public int getValidationLevel()
	{
		return validationLevel;
	}

	public void setValidationLevel(int validationLevel)
	{
		this.validationLevel = validationLevel;
	}

	public String getGridValidationField()
	{
		return gridValidationField;
	}

	public void setGridValidationField(String gridValidationField)
	{
		this.gridValidationField = gridValidationField;
	}

	public void cloneTo(FieldInformation fieldInformation)
	{
		fieldInformation.fieldId = this.fieldId;
		fieldInformation.hasPostAction = this.hasPostAction;
		fieldInformation.hasSearchContext = this.hasSearchContext;
		fieldInformation.needsValidation = this.needsValidation;
		fieldInformation.postActionContextFields = this.postActionContextFields;
		fieldInformation.sumsFields = this.sumsFields;
		fieldInformation.prevalidatFields = this.prevalidatFields;
		fieldInformation.preValidationContextFields = this.preValidationContextFields;
		fieldInformation.searchContextFields = this.searchContextFields;
		fieldInformation.validationContextFields = this.searchContextFields;
		fieldInformation.hasGridAction = this.hasGridAction;
		fieldInformation.gridActionContextFields = this.gridActionContextFields;
		fieldInformation.gridActions = this.gridActions;
		fieldInformation.hasSuggestionProvider = this.hasSuggestionProvider;
		fieldInformation.suggestionProviderContextFields = this.suggestionProviderContextFields;
		fieldInformation.validationLevel = this.validationLevel;
		fieldInformation.gridValidationField = this.gridValidationField;
		fieldInformation.dynamicSearchContextFields = this.dynamicSearchContextFields;
	}

	public boolean isHasPostAction()
	{
		return hasPostAction;
	}

	public boolean isHasPreValidation()
	{
		return hasPreValidation;
	}

	public boolean isHasQuickCreator()
	{
		return hasQuickCreator;
	}

	public boolean isHasSearchContext()
	{
		return hasSearchContext;
	}

	public Set<String> getDynamicSearchContextFields()
	{
		return dynamicSearchContextFields;
	}

	public void setDynamicSearchContextFields(Set<String> dynamicSearchContextFields)
	{
		this.dynamicSearchContextFields = dynamicSearchContextFields;
	}
}
