package com.namasoft.common.layout.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import com.namasoft.common.HasIDUtil;
import com.namasoft.common.HasId;

@SuppressWarnings("serial")
public class GUIActionInfo implements Serializable, HasId
{
	private List<String> questions = new ArrayList<String>();
	private List<String> contextFields = new ArrayList<String>();
	private List<FieldMetaData> questionsMetadata = new ArrayList<FieldMetaData>();
	private String actionInitializerClassName;
	private String id;
	private String relatedtoFeature;
	private boolean mustBeSaved = false;
	private transient boolean generic = false;

	public String getActionInitializerClassName()
	{
		return actionInitializerClassName;
	}

	public void setActionInitializerClassName(String actionInitializerClassName)
	{
		this.actionInitializerClassName = actionInitializerClassName;
	}

	public List<String> getQuestions()
	{
		return questions;
	}

	public void setQuestions(List<String> questions)
	{
		this.questions = questions;
	}

	public List<String> getContextFields()
	{
		return contextFields;
	}

	public void setContextFields(List<String> contextFields)
	{
		this.contextFields = contextFields;
	}

	public List<FieldMetaData> getQuestionsMetadata()
	{
		return questionsMetadata;
	}

	public void setQuestionsMetadata(List<FieldMetaData> questionsMetadata)
	{
		this.questionsMetadata = questionsMetadata;
	}

	public String getId()
	{
		return id;
	}

	public void setId(String id)
	{
		this.id = id;
	}

	public String getRelatedtoFeature()
	{
		return relatedtoFeature;
	}

	public void setRelatedtoFeature(String relatedtoFeature)
	{
		this.relatedtoFeature = relatedtoFeature;
	}

	public boolean isMustBeSaved()
	{
		return mustBeSaved;
	}

	public void setMustBeSaved(boolean mustBeSaved)
	{
		this.mustBeSaved = mustBeSaved;
	}

	public FieldMetaData getQuestionMetadata(String id)
	{
		return HasIDUtil.find(id, getQuestionsMetadata());
	}

	public boolean isGeneric()
	{
		return generic;
	}

	public void setGeneric(boolean generic)
	{
		this.generic = generic;
	}

}
