package com.namasoft.common.layout.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;

import com.namasoft.common.EntityActionDefintion;

@XmlAccessorType(XmlAccessType.PROPERTY)
public class ModuleEntitiesMetaData implements Serializable
{
	private static final long serialVersionUID = -3725146853490745174L;
	private List<EntityTypeMetaData> entityTypesMetaData = new ArrayList<EntityTypeMetaData>();
	private List<EntityActionDefintion> entityActionDefintions = new ArrayList<EntityActionDefintion>();
	private List<EntityTypeMetaData> simpleEntitiesMetaData = new ArrayList<EntityTypeMetaData>();
	private String moduleId;

	public ModuleEntitiesMetaData()
	{
	}

	public List<EntityTypeMetaData> getEntityTypesMetaData()
	{
		return entityTypesMetaData;
	}

	public void setEntityTypesMetaData(List<EntityTypeMetaData> entityCodesMetaData)
	{
		this.entityTypesMetaData = entityCodesMetaData;
	}

	public List<EntityActionDefintion> getEntityActionDefintions()
	{
		return entityActionDefintions;
	}

	public void setEntityActionDefintions(List<EntityActionDefintion> entityActionDefintions)
	{
		this.entityActionDefintions = entityActionDefintions;
	}

	public String getModuleId()
	{
		return moduleId;
	}

	public void setModuleId(String moduleId)
	{
		this.moduleId = moduleId;
	}

	public List<EntityTypeMetaData> getSimpleEntitiesMetaData()
	{
		return simpleEntitiesMetaData;
	}

	public void setSimpleEntitiesMetaData(List<EntityTypeMetaData> simpleEntitiesMetaData)
	{
		this.simpleEntitiesMetaData = simpleEntitiesMetaData;
	}

	public EntityTypeMetaData getEntity(String entityType)
	{
		for (EntityTypeMetaData entityTypeMetaData : entityTypesMetaData)
		{
			if (entityTypeMetaData.getEntityType().equals(entityType))
				return entityTypeMetaData;
		}
		return null;
	}

	public EntityTypeMetaData getSimpleEntity(String entityType)
	{
		for (EntityTypeMetaData entityTypeMetaData : simpleEntitiesMetaData)
		{
			if (entityTypeMetaData.getEntityType().equals(entityType))
				return entityTypeMetaData;
		}
		return null;
	}
}
