package com.namasoft.common.layout.metadata;

import java.io.Serializable;
import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;

import com.namasoft.common.ResultDTO;
import com.namasoft.common.ServiceResponse;

@XmlAccessorType(XmlAccessType.PROPERTY)
public class ModuleMetaData extends ServiceResponse implements Serializable
{
	private static final long serialVersionUID = 4572096754651534965L;
	private ModuleEntitiesMetaData entitiesMetaData;
	private List<EnumMetaData> availableEnums;
	private List<String> definedfeatures;
	private List<String> definedProperties;
	private List<String> embededModules;

	public ModuleMetaData()
	{
		this(ResultDTO.success());
	}

	public ModuleMetaData(ResultDTO result)
	{
		setResult(result);
	}

	public ModuleEntitiesMetaData getEntitiesMetaData()
	{
		return entitiesMetaData;
	}

	public void setEntitiesMetaData(ModuleEntitiesMetaData entitiesMetaData)
	{
		this.entitiesMetaData = entitiesMetaData;
	}

	public List<EnumMetaData> getAvailableEnums()
	{
		return availableEnums;
	}

	public void setAvailableEnums(List<EnumMetaData> availableEnums)
	{
		this.availableEnums = availableEnums;
	}

	public List<String> getDefinedfeatures()
	{
		return definedfeatures;
	}

	public void setDefinedfeatures(List<String> definedfeatures)
	{
		this.definedfeatures = definedfeatures;
	}

	public List<String> getDefinedProperties()
	{
		return definedProperties;
	}

	public void setDefinedProperties(List<String> definedProperties)
	{
		this.definedProperties = definedProperties;
	}

	public List<String> getEmbededModules()
	{
		return embededModules;
	}

	public void setEmbededModules(List<String> embededModules)
	{
		this.embededModules = embededModules;
	}

}
