package com.namasoft.common.layout.metadata;

import com.namasoft.common.layout.Owner;
import com.namasoft.common.utilities.*;

import jakarta.xml.bind.annotation.*;
import java.io.Serializable;
import java.util.*;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
@SuppressWarnings("serial")
public class NaMaMetaData implements Serializable
{
	private Owner owner;
	private List<FieldMetaData> fieldsMetaData = new ArrayList<FieldMetaData>();
	private List<FieldMetaData> detailsMetaData = null;

	private EntityGUIActions entityActions;
	private String relatedToFeature;

	public Owner getOwner()
	{
		return owner;
	}

	public void setOwner(Owner owner)
	{
		this.owner = owner;
	}

	public List<FieldMetaData> getFieldsMetaData()
	{
		return fieldsMetaData;
	}

	public void setFieldsMetaData(List<FieldMetaData> fieldsMetaData)
	{
		this.fieldsMetaData = fieldsMetaData;
	}

	public EntityGUIActions getEntityActions()
	{
		if (entityActions == null)
			entityActions = new EntityGUIActions();
		return entityActions;
	}

	public void setEntityActions(EntityGUIActions entityActions)
	{
		this.entityActions = entityActions;
	}

	public String getRelatedToFeature()
	{
		return relatedToFeature;
	}

	public void setRelatedToFeature(String relatedToFeature)
	{
		this.relatedToFeature = relatedToFeature;
	}

	public FieldMetaData getFieldMetadata(String id)
	{
		long start = System.currentTimeMillis();
		int index = getFieldIdIndex(id, getFieldsMetaData());
		long end = System.currentTimeMillis();
		if (end - start > 3)
			NaMaLogger.debug(id + " Takes " + (end - start));
		if (index < 0)
			return null;
		return getFieldsMetaData().get(index);
	}

	private int getFieldIdIndex(String id, List<FieldMetaData> toSearchList)
	{
		int i = 0;
		for (FieldMetaData fieldMetaData : toSearchList)
		{
			if (fieldMetaData.getId().equals(id))
			{
				return i;
			}
			i++;
		}
		return -1;
	}

	public List<String> listAllCalculatedFields()
	{
		List<String> guiFields = new ArrayList<String>();
		for (FieldMetaData metaData : getFieldsMetaData())
		{
			if (metaData.isCalculated())
				guiFields.add(metaData.getFieldId());
		}
		return guiFields;
	}

	public String getFieldParentDetail(String fieldId)
	{
		return getFieldParentDetail0(fieldId, true);
	}

	private String getFieldParentDetail0(String fieldId, boolean firstCall)
	{
		if (detailsMetaData == null)
			initDetailsMetaData();
		if (ObjectChecker.isEmptyOrNull(fieldId))
			return null;
		FieldMetaData fieldMetadata = null;
		if (firstCall)
			fieldMetadata = getFieldMetadata(fieldId);
		else
			fieldMetadata = getDetailFieldMetadata(fieldId);
		if (fieldMetadata != null && !firstCall)
		{
			return fieldId;
		}
		int lastDotIndex = fieldId.lastIndexOf('.');
		if (lastDotIndex < 0)
			return null;
		fieldId = fieldId.substring(0, lastDotIndex);
		return getFieldParentDetail0(fieldId, false);
	}

	private FieldMetaData getDetailFieldMetadata(String fieldId)
	{
		int index = getFieldIdIndex(fieldId, detailsMetaData);
		if (index < 0)
			return null;
		return getFieldsMetaData().get(index);
	}

	private void initDetailsMetaData()
	{
		detailsMetaData = new ArrayList<FieldMetaData>();
		for (FieldMetaData metaData : fieldsMetaData)
		{
			if (metaData.isDetail())
				detailsMetaData.add(metaData);
		}
	}
}
