package com.namasoft.common.layout.metadata;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.flatobjects.EntityReferenceData;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class TemplateMetadata extends NaMaDTO
{
	private EntityReferenceData template;
	private String entityType;
	private String cursorField;
	private DTOCMNKeyboardShortcut shortcut;
	private Boolean doNotAddToMoreMenu;
	public TemplateMetadata()
	{
	}

	public TemplateMetadata(EntityReferenceData template, String entityType, DTOCMNKeyboardShortcut shortcut, String cursorField,
			Boolean doNotAddToMoreMenu)
	{
		this();
		this.template = template;
		this.entityType = entityType;
		this.shortcut = shortcut;
		this.cursorField = cursorField;
		this.doNotAddToMoreMenu = doNotAddToMoreMenu;
	}

	public EntityReferenceData getTemplate()
	{
		return template;
	}

	public void setTemplate(EntityReferenceData template)
	{
		this.template = template;
	}

	public String getEntityType()
	{
		return entityType;
	}

	public void setEntityType(String entityType)
	{
		this.entityType = entityType;
	}

	public DTOCMNKeyboardShortcut getShortcut()
	{
		return shortcut;
	}

	public void setShortcut(DTOCMNKeyboardShortcut shortcut)
	{
		this.shortcut = shortcut;
	}

	public String getCursorField()
	{
		return cursorField;
	}

	public void setCursorField(String cursorField)
	{
		this.cursorField = cursorField;
	}

	public Boolean getDoNotAddToMoreMenu()
	{
		return doNotAddToMoreMenu;
	}

	public void setDoNotAddToMoreMenu(Boolean doNotAddToMoreMenu)
	{
		this.doNotAddToMoreMenu = doNotAddToMoreMenu;
	}
}
