package com.namasoft.common.layout.metadata;

import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.layout.Owner;
import com.namasoft.common.layout.ViewName;
import com.namasoft.common.layout.edit.EditScreenLayout;
import com.namasoft.common.layout.list.ListScreenLayout;
import com.namasoft.common.layout.search.SearcherScreenLayout;
import com.namasoft.common.preferences.ListLayoutPreferences;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class UIPreferences extends NaMaDTO
{
	private Owner owner;
	private EditScreenLayout editLayout;
	private ListScreenLayout listLayout;
	private NaMaMetaData metaData;
	private SearcherScreenLayout searcherLayout;
	private List<ViewName> viewNames;
	private ListLayoutPreferences listLayoutPreferences;

	public Owner getOwner()
	{
		return owner;
	}

	public void setOwner(Owner owner)
	{
		this.owner = owner;
	}

	public EditScreenLayout getEditLayout()
	{
		return editLayout;
	}

	public void setEditLayout(EditScreenLayout editLayout)
	{
		this.editLayout = editLayout;
	}

	public ListScreenLayout getListLayout()
	{
		return listLayout;
	}

	public void setListLayout(ListScreenLayout listLayout)
	{
		this.listLayout = listLayout;
	}

	public NaMaMetaData getMetaData()
	{
		return metaData;
	}

	public void setMetaData(NaMaMetaData metaData)
	{
		this.metaData = metaData;
	}

	public SearcherScreenLayout getSearcherLayout()
	{
		return searcherLayout;
	}

	public void setSearcherLayout(SearcherScreenLayout searcherLayout)
	{
		this.searcherLayout = searcherLayout;
	}

	public List<ViewName> getViewNames()
	{
		return viewNames;
	}

	public void setViewNames(List<ViewName> viewNames)
	{
		this.viewNames = viewNames;
	}

	public ListLayoutPreferences getListLayoutPreferences()
	{
		return listLayoutPreferences;
	}

	public void setListLayoutPreferences(ListLayoutPreferences listLayoutPreferences)
	{
		this.listLayoutPreferences = listLayoutPreferences;
	}

	public UIPreferences editLayout(EditScreenLayout editScreenLayout)
	{
		setEditLayout(editScreenLayout);
		return this;
	}

	public UIPreferences metaData(NaMaMetaData metaData)
	{
		setMetaData(metaData);
		return this;
	}

	public UIPreferences searcherLayout(SearcherScreenLayout searcherLayout)
	{
		setSearcherLayout(searcherLayout);
		return this;
	}

}
