package com.namasoft.common.layout.search;

import com.namasoft.common.HasIDUtil;
import com.namasoft.common.HasId;
import com.namasoft.common.criteria.DTOCriteria;
import com.namasoft.common.layout.ScreenLayout;
import com.namasoft.common.layout.edit.EditScreenLayout;
import com.namasoft.common.layout.list.*;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.Converter;
import com.namasoft.common.utilities.Filter;
import com.namasoft.common.utilities.ObjectChecker;

import jakarta.xml.bind.annotation.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class SearcherScreenLayout extends AbsListScreen
{
	private List<String> searchableFields = new ArrayList<String>();
	private List<String> sortableFields = new ArrayList<String>();
	private String searchViewWidth;
	private SearcherScreenLayout mobileScreen;

	@Override
	public List<String> fetchProperties()
	{
		return getDisplayColumns().stream().filter(c -> c.getColumnType() == null && ObjectChecker.isEmptyOrNull(c.getSources()) && ObjectChecker
				.isEmptyOrNull(c.getSourceColumn())).map(HasId::getId).collect(Collectors.toList());
	}

	@XmlElementWrapper(name = "searchableFields")
	@XmlElement(name = "searchableField")
	public List<String> getSearchableFields()
	{
		return searchableFields;
	}

	public void setSearchableFields(List<String> searchableFields)
	{
		this.searchableFields = searchableFields;
	}

	@XmlElementWrapper(name = "sortableFields")
	@XmlElement(name = "sortableField")
	public List<String> getSortableFields()
	{
		return sortableFields;
	}

	@Override
	public List<String> fetchSortColumnIds()
	{
		return getSortableFields() == null ? new ArrayList<>() : getSortableFields();
	}

	public void setSortableFields(List<String> sortableFields)
	{
		this.sortableFields = sortableFields;
	}

	public SearcherScreenLayout addDisplayedFields(String... displayColumns)
	{
		getDisplayColumns().addAll(ListScreenColumn.ofDisplayed(displayColumns));
		return this;
	}

	public SearcherScreenLayout addHiddenFields(String... displayColumns)
	{
		getDisplayColumns().addAll(ListScreenColumn.ofHidden(displayColumns));
		return this;
	}

	public SearcherScreenLayout addSortableFields(String... sortableFields)
	{
		getSortableFields().addAll(Arrays.asList(sortableFields));
		return this;
	}

	public SearcherScreenLayout addSearchableFields(String... searchableFields)
	{
		getSearchableFields().addAll(Arrays.asList(searchableFields));
		return this;
	}

	public List<String> getDisplayColumnsIds()
	{
		return CollectionsUtility.convert(getDisplayColumns(), HasId::getId);
	}

	public SearcherScreenLayout sameAs(ListScreenLayout listLayout)
	{
		if (ObjectChecker.isEmptyOrNull(getOwner()))
			setOwner(listLayout.getOwner());
		for (CriteriaField field : listLayout.getCriteriaFields())
		{
			if (getCriteriaField(field.getId()) == null)
				getCriteriaFields().addAll(CriteriaField.of(field.getId()));
		}
		for (SortColumn orderField : listLayout.getSortColumns())
		{
			if (!getSortableFields().contains(orderField.getId()))
				getSortableFields().add(orderField.getId());
		}
		if (ObjectChecker.isEmptyOrNull(getDefaultOrderBy()) && ObjectChecker.isNotEmptyOrNull(listLayout.getDefaultOrderBy()))
		{
			setDefaultOrderBy(listLayout.getDefaultOrderBy());
		}
		if (ObjectChecker.isEmptyOrNull(getDefaultSortType()) && ObjectChecker.isNotEmptyOrNull(listLayout.getDefaultSortType()))
		{
			setDefaultSortType(listLayout.getDefaultSortType());
		}
		return this;
	}

	public List<ListScreenColumn> visibleColumns()
	{
		return CollectionsUtility.filter(getDisplayColumns(), new Filter<ListScreenColumn>()
		{
			@Override
			public boolean include(ListScreenColumn object)
			{
				return object.isDisplayed();
			}
		});
	}

	public SearcherScreenLayout selectable()
	{
		setSelectable(true);
		return this;
	}

	public SearcherScreenLayout notSelectable()
	{
		setSelectable(false);
		return this;
	}

	public String getSearchViewWidth()
	{
		return searchViewWidth;
	}

	public void setSearchViewWidth(String searchViewWidth)
	{
		this.searchViewWidth = searchViewWidth;
	}

	public SearcherScreenLayout objectBased(Class<?> objectClass, String objectName)
	{
		return (SearcherScreenLayout) super.objectBased(objectClass, objectName);
	}

	public SearcherScreenLayout oql(String oql)
	{
		return (SearcherScreenLayout) super.oql(oql);
	}

	public void prefixEveryThing(String prefix, Function<ListScreenColumn, ListScreenColumn> cloner)
	{
		setSearchContextCriteriaPrefix(prefix);
		super.prefixEveryThing(prefix, cloner);
		for (int i = 0; i < getSortableFields().size(); i++)
		{
			getSortableFields().set(i, prefix + "." + getSortableFields().get(i));
		}
		for (int i = 0; i < getSearchableFields().size(); i++)
		{
			getSearchableFields().set(i, prefix + "." + getSortableFields().get(i));
		}
	}

	public SearcherScreenLayout getMobileScreen()
	{
		return mobileScreen;
	}

	public void setMobileScreen(SearcherScreenLayout mobileScreen)
	{
		this.mobileScreen = mobileScreen;
	}

	@Override
	public SearcherScreenLayout fetchMobileScreen()
	{
		return getMobileScreen();
	}

	public SearcherScreenLayout addCriteriaFields(String... ids)
	{
		getCriteriaFields().addAll(CriteriaField.of(ids));
		return this;
	}
}
