package com.namasoft.common.objects;

import com.namasoft.common.flatobjects.FlatObjectPrimitive;
import com.namasoft.common.utilities.ObjectChecker;

import jakarta.xml.bind.annotation.*;
import java.io.Serializable;

@XmlAccessorType(XmlAccessType.PROPERTY)
public class DTOFileAttachmentInfo implements Serializable, FlatObjectPrimitive
{
	private static final long serialVersionUID = -8139911768744555056L;

	private String fileName = "";
	private String fileId = "";
	private String base64DataForReplication;
	private boolean updated = false;
	private boolean removed = false;
	private Boolean decodeBase64UsingStandardLib;

	public String getFileName()
	{
		return fileName;
	}

	public void setFileName(String fileName)
	{
		this.fileName = fileName;
	}

	public String getFileId()
	{
		return fileId;
	}

	public void setFileId(String fileId)
	{
		this.fileId = fileId;
	}

	public boolean isUpdated()
	{
		return updated;
	}

	public void setUpdated(boolean updated)
	{
		this.updated = updated;
	}

	public boolean isRemoved()
	{
		return removed;
	}

	public void setRemoved(boolean removed)
	{
		this.removed = removed;
	}

	@Override
	public boolean equals(Object obj)
	{
		if (obj == null || !getClass().equals(obj.getClass()))
			return false;
		DTOFileAttachmentInfo obj1 = (DTOFileAttachmentInfo) obj;
		if (ObjectChecker.areNotEqual(getFileId(), obj1.getFileId()))
			return false;
		if (ObjectChecker.areNotEqual(getFileName(), obj1.getFileName()))
			return false;
		if (ObjectChecker.areNotEqual(isRemoved(), obj1.isRemoved()))
			return false;
		if (ObjectChecker.areNotEqual(isUpdated(), obj1.isUpdated()))
			return false;
		return true;
	}

	public Object clone1()
	{
		DTOFileAttachmentInfo dto = new DTOFileAttachmentInfo();
		dto.setFileId(getFileId());
		dto.setFileName(getFileName());
		dto.setRemoved(isRemoved());
		dto.setUpdated(isUpdated());
		dto.setBase64DataForReplication(getBase64DataForReplication());
		return dto;
	}

	public String getBase64DataForReplication()
	{
		return base64DataForReplication;
	}

	public void setBase64DataForReplication(String base64DataForReplication)
	{
		this.base64DataForReplication = base64DataForReplication;
	}

	public Boolean getDecodeBase64UsingStandardLib()
	{
		return decodeBase64UsingStandardLib;
	}

	public void setDecodeBase64UsingStandardLib(Boolean decodeBase64UsingStandardLib)
	{
		this.decodeBase64UsingStandardLib = decodeBase64UsingStandardLib;
	}
}
