package com.namasoft.common.treemodels;

import com.namasoft.common.HasId;
import com.namasoft.common.constants.Operator;
import com.namasoft.common.criteria.DTOExperssion;
import com.namasoft.common.utilities.ObjectChecker;

import java.util.*;

public abstract class BaseTreeFilterHelper implements TreeFilterHelper
{
	private final String propertyName;

	public BaseTreeFilterHelper(String propertyName)
	{
		this.propertyName = propertyName;
	}

	@Override
	public List<DTOExperssion> createSelectedNodeExpressions(HasId selectedNode)
	{
		if (ObjectChecker.isEmptyOrNull(selectedNode))
			return Arrays.asList();
		return Arrays.asList(addFilter(selectedNode.getId()));
	}

	private DTOExperssion addFilter(String value)
	{
		return new DTOExperssion(propertyName, getOperator(), processValue(value));
	}

	protected abstract Object processValue(String value);

	protected Operator getOperator()
	{
		return Operator.Contains;
	}

}
