package com.namasoft.common.urlutils;

import java.util.HashMap;
import java.util.List;

import com.namasoft.common.constants.Operator;
import com.namasoft.common.criteria.DTOCriteria;
import com.namasoft.common.criteria.DTOExperssion;
import com.namasoft.common.criteria.DTOFilledQuestionField;
import com.namasoft.common.criteria.ExpressionRelationship;
import com.namasoft.common.utilities.ObjectChecker;

public class CriteriaAndQuestionsURLParser
{
	private static final String IN_VALUES = "inv";
	private static final String RIGHT_HAND_SIDE = "rhs";
	private static final String OPERATOR = "op";
	private static final String ID = "id";
	private static final String RELATIONSHIP = "rltn";
	private static final String VALUE = "vlu";
	private static final PropertySerializer<DTOExperssion> CRITERIA_EXPRESSION_SERIALIZER = new PropertySerializer<DTOExperssion>()
	{

		@Override
		public HashMap<String, String> toProperties(DTOExperssion expression)
		{
			HashMap<String, String> map = new HashMap<String, String>();
			map.put(ID, expression.getField());
			map.put(OPERATOR, ObjectChecker.toStringOrEmpty(expression.getOperator()));
			map.put(RIGHT_HAND_SIDE, expression.getRightHandSide());
			map.put(RELATIONSHIP, ObjectChecker.toStringOrEmpty(expression.getRelation()));
			map.put(IN_VALUES, ObjectToURLUtil.listToString(expression.getInValues()));
			return map;
		}

		@Override
		public DTOExperssion fromProperties(HashMap<String, String> peoperties)
		{
			DTOExperssion dtoExperssion = new DTOExperssion();
			dtoExperssion.setField(peoperties.get(ID));
			if (ObjectChecker.isNotEmptyOrNull(peoperties.get(OPERATOR)))
				dtoExperssion.setOperator(Operator.valueOf(peoperties.get(OPERATOR)));
			dtoExperssion.setRightHandSide(peoperties.get(RIGHT_HAND_SIDE));
			if (ObjectChecker.isNotEmptyOrNull(peoperties.get(RELATIONSHIP)))
				dtoExperssion.setRelation(ExpressionRelationship.valueOf(peoperties.get(RELATIONSHIP)));
			dtoExperssion.setInValues(ObjectToURLUtil.stringToList(peoperties.get(IN_VALUES)));
			return dtoExperssion;
		}
	};

	private static final PropertySerializer<DTOFilledQuestionField> FILLED_QUESTION_FIELDS_SERIALIZER = new PropertySerializer<DTOFilledQuestionField>()
	{
		@Override
		public HashMap<String, String> toProperties(DTOFilledQuestionField object)
		{
			HashMap<String, String> map = new HashMap<String, String>();
			map.put(ID, object.getId());
			map.put(VALUE, object.getValue());
			return map;
		}

		@Override
		public DTOFilledQuestionField fromProperties(HashMap<String, String> peoperties)
		{
			return new DTOFilledQuestionField(peoperties.get(ID), peoperties.get(VALUE), null);
		}
	};

	public static void main(String[] args)
	{
		List<DTOFilledQuestionField> l1 = ObjectToURLUtil
				.fromURL(
						"aWRfbmtfRnBlcmlvZF9udHJfdmx1X25rX2ZmZmYwMDAxLTc1ZGMtZTQ4My04YzAwLTAyMDBmZjc2NGEyYjpGaXNjYWxQZXJpb2Q6MjAyMDAxOjIwMjAwMTrZitmG2KfZitixOtmK2YbYp9mK2LFfbmN0eF9pZF9ua19UcGVyaW9kX250cl92bHVfbmtfZmZmZjAwMDEtNzVkYy1lNDgzLThjMDAtMTIwMGZmNzBhNjc1OkZpc2NhbFBlcmlvZDoyMDIwMDI6MjAyMDAyOtmB2KjYsdin2YrYsTrZgdio2LHYp9mK2LFfbmN0eF9pZF9ua19GbGVnYWxFbnRpdHlfbnRyX3ZsdV9ua19udWxsX25jdHhfaWRfbmtfVGxlZ2FsRW50aXR5X250cl92bHVfbmtfbnVsbF9uY3R4X2lkX25rX0ZCcmFuY2hfbnRyX3ZsdV9ua19udWxsX25jdHhfaWRfbmtfVEJyYW5jaF9udHJfdmx1X25rX251bGxfbmN0eF9pZF9ua19GU2VjdG9yX250cl92bHVfbmtfbnVsbF9uY3R4X2lkX25rX1RTZWN0b3JfbnRyX3ZsdV9ua19udWxsX25jdHhfaWRfbmtfRkRlcGFydG1lbnRfbnRyX3ZsdV9ua19udWxsX25jdHhfaWRfbmtfVERlcGFydG1lbnRfbnRyX3ZsdV9ua19udWxsX25jdHhfaWRfbmtfRkFuYWx5c2lzU2V0X250cl92bHVfbmtfbnVsbF9uY3R4X2lkX25rX1RBbmFseXNpc1NldF9udHJfdmx1X25rX251bGxfbmN0eF9pZF9ua19IaWRlWmVyb0FjY19udHJfdmx1X25rX3RydWVfbmN0eF9pZF9ua19IaWRlRXF1YWxUcmFuc19udHJfdmx1X25rX3RydWVfbmN0eF9pZF9ua19VcFRvTGV2ZWxfbnRyX3ZsdV9ua18xMDA=",
						FILLED_QUESTION_FIELDS_SERIALIZER);
		List<DTOFilledQuestionField> l2 = ObjectToURLUtil
				.fromURL(
						"aWRfbmtfU2VjdG9yX250cl92bHVfbmtfX25jdHhfaWRfbmtfTGVnYWxFbnRpdHlfbnRyX3ZsdV9ua19fbmN0eF9pZF9ua19BbmFseXNpc1NldF9udHJfdmx1X25rX19uY3R4X2lkX25rX2VudGl0eVR5cGVfbnRyX3ZsdV9ua19GaXhlZEFzc2V0X25jdHhfaWRfbmtfRnJvbUJyYW5jaF9udHJfdmx1X25rX19uY3R4X2lkX25rX1RvQnJhbmNoX250cl92bHVfbmtfX25jdHhfaWRfbmtfZnJvbURhdGVfbnRyX3ZsdV9ua18wMS0wMS0yMDE1X25jdHhfaWRfbmtfdG9EYXRlX250cl92bHVfbmtfMzEtMTAtMjAxNV9uY3R4X2lkX25rX0Zyb21TdWJDb2RlX250cl92bHVfbmtfX25jdHhfaWRfbmtfVG9TdWJDb2RlX250cl92bHVfbmtfX25jdHhfaWRfbmtfU29ydEJ5MV9udHJfdmx1X25rX3ZhbHVlRGF0ZV9uY3R4X2lkX25rX1NvcnRCeTJfbnRyX3ZsdV9ua19vcmlnaW5Db2RlX25jdHhfaWRfbmtfU2hvd0RldGFpbHNfbnRyX3ZsdV9ua190cnVlX25jdHhfaWRfbmtfc2hvd0N1cnJlbnRFbXBsb3llZU9ubHlfbnRyX3ZsdV9ua19mYWxzZV9uY3R4X2lkX25rX0Zyb21BY2NvdW50Q29kZV9udHJfdmx1X25rX2ZmZmYwMDAxLTRmMjYtYTdkZS1iMDAwLTEyMDBmZjAwMTU4NzpBY2NvdW50OjExMDEwNDrYo9ir2KfYqyDZiNmF2YHYsdmI2LTYp9iqOkZ1cm5pdHVyZTpfbmN0eF9pZF9ua19Ub0FjY291bnRDb2RlX250cl92bHVfbmtfZmZmZjAwMDEtNGYyNi1hN2RlLWIwMDAtMTIwMGZmMDAxNTg3OkFjY291bnQ6MTEwMTA0Otij2KvYp9irINmI2YXZgdix2YjYtNin2Ko6RnVybml0dXJlOl9uY3R4X2lkX25rX3Nob3dBbnlfbnRyX3ZsdV9ua19mYWxzZQ==",
						FILLED_QUESTION_FIELDS_SERIALIZER);
		System.out.println(l1);
		System.out.println(l2);

	}

	public static String toURL(DTOCriteria criteria)
	{
		if (ObjectChecker.isEmptyOrNull(criteria))
			return "";
		return ObjectToURLUtil.toUrl(criteria.getExpressions(), CRITERIA_EXPRESSION_SERIALIZER);
	}

	public static String toURL(List<DTOFilledQuestionField> filledQuestionFields)
	{
		return ObjectToURLUtil.toUrl(filledQuestionFields, FILLED_QUESTION_FIELDS_SERIALIZER);
	}

	public static DTOCriteria criteriaFromURL(String url)
	{
		return new DTOCriteria(ObjectToURLUtil.<DTOExperssion> fromURL(url, CRITERIA_EXPRESSION_SERIALIZER));
	}

	public static List<DTOFilledQuestionField> questionsFromURL(String url)
	{
		return ObjectToURLUtil.fromURL(url, FILLED_QUESTION_FIELDS_SERIALIZER);
	}

}
