package com.namasoft.common.urlutils;

import com.namasoft.common.HasIDUtil;
import com.namasoft.common.constants.*;
import com.namasoft.common.criteria.DTOFilledQuestionField;
import com.namasoft.common.flatobjects.*;
import com.namasoft.common.layout.list.QuestionField;
import com.namasoft.common.layout.metadata.*;
import com.namasoft.common.utilities.*;
import com.namasoft.common.utils.*;
import com.namasoft.common.utils.translation.TranslationUtil;

import java.util.*;
import java.util.stream.Collectors;

import static com.namasoft.common.constants.PlaceTokens.*;
import static com.namasoft.common.utilities.NaMaKeyValuePairsTokenizer.pair;

public class ReportQuestions
{
	private EntityReferenceData reportReference;
	private ReportMetadata reportMetada;
	private List<DTOFilledQuestionField> filledQuestions = new ArrayList<DTOFilledQuestionField>();
	private Parameter p = new Parameter();
	private HashMap<String, String> caseInsensitiveParams;
	private boolean performChecks;
	private String reportId;
	private Map<Object, Object> reportParameters = new HashMap<Object, Object>();

	public ReportQuestions(ReportMetadata reportMetada, EntityReferenceData reportReference, boolean performChecks,
			HashMap<Object, Object> reportParameters)
	{
		this.reportMetada = reportMetada;
		this.reportId = reportReference.getId();
		this.reportReference = reportReference;
		if (performChecks)
		{
			caseInsensitiveParams = new HashMap<String, String>();
			for (QuestionField question : reportMetada.getQuestionFields())
			{
				caseInsensitiveParams.put(question.getId().toLowerCase().trim(), question.getId());
			}
		}
		this.reportParameters = reportParameters;
	}

	public ReportMetadata getReportMetada()
	{
		return reportMetada;
	}

	public void setReportMetada(ReportMetadata reportMetada)
	{
		this.reportMetada = reportMetada;
	}

	public List<DTOFilledQuestionField> getFilledQuestions()
	{
		return filledQuestions;
	}

	public void setFilledQuestions(List<DTOFilledQuestionField> filledQuestions)
	{
		this.filledQuestions = filledQuestions;
	}

	public class Parameter
	{
		private DTOFilledQuestionField questionField = new DTOFilledQuestionField();

		private Parameter()
		{
		}

		public Parameter p(Object id)
		{
			String idStr = ObjectChecker.toStringOrEmpty(id);
			if (performChecks)
			{
				idStr = idStr.trim().toLowerCase();
				if (questionField.getId() != null)
					throw new RuntimeException("You have set the id twice, check your expression. Current: " + questionField.getId() + ", New:" + id
							+ guessPrevious());
				if (ObjectChecker.isEmptyOrNull(idStr))
					throw new RuntimeException("Can not set empty id" + guessPrevious());
				if (!caseInsensitiveParams.containsKey(idStr))
				{
					throw new RuntimeException("Could not find parameter with id " + idStr + guessPrevious());
				}
				idStr = caseInsensitiveParams.get(idStr);
			}
			questionField.setId(idStr);
			return this;
		}

		public Parameter ref(Object entityType, Object value)
		{
			return v(NaMaLayersConnector.getInstance()
					.refById(ObjectChecker.toStringOrEmpty(entityType), ObjectChecker.toStringOrEmpty(preProcessValue(value))));
		}

		public Parameter list(Object... objects)
		{
			QuestionField questionMetdata = HasIDUtil.find(questionField.getId(), reportMetada.getQuestionFields());
			if (objects.length == 1 && objects[0] instanceof List)
				objects = ((List<?>) objects[0]).toArray();
			List<String> fieldValues = new ArrayList<String>();
			for (int i = 0; i < objects.length; i++)
			{
				fieldValues.add(FieldTypesUtils.toString(questionMetdata.getFieldType(), objects[i]));
			}
			return v(StringUtils.toCSVLineWithSep(CommonConstants.LIST_PARAMS_SEP, fieldValues));
		}

		public Parameter refCode(Object entityType, Object code)
		{
			return v(NaMaLayersConnector.getInstance().refByCode(ObjectChecker.toStringOrEmpty(entityType), ObjectChecker.toStringOrEmpty(code)));
		}

		public Parameter v(Object value)
		{
			return v(new Object[] { value });
		}

		public Parameter v(Object... valueArr)
		{
			Object value = preProcess(valueArr);
			if (value instanceof String && value.toString().startsWith("@"))
			{
				String paramValueId = value.toString().substring(1);
				if (reportParameters.containsKey(CommonConstants.REPORT_PARAM_ORIGINAL_PREFIX + paramValueId))
					paramValueId = CommonConstants.REPORT_PARAM_ORIGINAL_PREFIX + paramValueId;
				value = reportParameters.get(paramValueId);
			}
			if (ObjectChecker.isEmptyOrNull(questionField.getId()))
				throw new RuntimeException("You have to set id first" + guessPrevious());
			if (ObjectChecker.isEmptyOrNull(value))
			{
				questionField.setValue("");
			}
			else
			{
				value = preProcessValue(value);
				QuestionField questionField = reportMetada.getQuestionField(this.questionField.getId());
				if (questionField == null)
				{
					NaMaLogger.error(new RuntimeException("Can not find parameter " + this.questionField.getId()));
					questionField = new QuestionField();
				}
				this.questionField.setValue(FieldTypesUtils.toString(questionField.getFieldType(), value));
			}

			getFilledQuestions().add(questionField);
			return p = new Parameter();
		}

		private Object preProcess(Object[] valueArr)
		{
			if (valueArr == null)
				return null;
			if (valueArr.length == 0)
				return null;
			if (valueArr.length == 1)
				return valueArr[0];
			String value = "";
			for (Object object : valueArr)
			{
				value += preProcessValue(object) + CommonConstants.FIELD_PARTS_SEP;
			}
			return value;
		}

		@Override
		public String toString()
		{
			return ReportQuestions.this.toString();
		}

		public String toNoAuthResultLink()
		{
			return ReportQuestions.this.toNoAuthResultLink();
		}

	}

	public static Object preProcessValue(Object value)
	{
		if (value != null && value.getClass().isArray())
			value = ServerCommonUtils.byteArrayToUUID((byte[]) value);
		if (value instanceof INamaEntityReference)
			return ((INamaEntityReference) value).toEntityReferenceData();
		return value;
	}

	public Parameter p(Object id)
	{
		return p.p(id);
	}

	private String guessPrevious()
	{
		if (ObjectChecker.isEmptyOrNull(getFilledQuestions()))
			return ".This happend in the first parameter";
		return ".This happened after setting parameter " + CollectionsUtility.getLast(getFilledQuestions()).getId();
	}

	public Parameter v(Object value)
	{
		return p.v(value);
	}

	public Parameter v(Object... value)
	{
		return p.v(value);
	}

	public Parameter ref(Object entityType, Object id)
	{
		return p.ref(entityType, id);
	}

	public Parameter refCode(Object entityType, Object code)
	{
		return p.refCode(entityType, code);
	}

	@Override
	public String toString()
	{
		String guiServerURL = calcGuiServerURL();
		return toResultLink(guiServerURL);
	}

	public static String calcGuiServerURL()
	{
		String localeStr = TranslationUtil.getCurrentLanguage() == Language.Arabic ? "ar" : "en";
		String guiServerURL = ObjectChecker.toStringOrEmpty(NaMaLayersConnector.getInstance().getGuiServerURL());
		if (!guiServerURL.contains("?"))
			guiServerURL = guiServerURL + "?locale=" + localeStr;
		return guiServerURL;
	}

	public String toNoAuthResultLink()
	{
		String localeStr = TranslationUtil.getCurrentLanguage() == Language.Arabic ? "ar" : "en";
		String guiServerURL = ObjectChecker.toStringOrEmpty(NaMaLayersConnector.getInstance().getGuiServerURL());
		if (guiServerURL.contains(".htm"))
			guiServerURL = StringUtils.substringBeforeLast(guiServerURL, "/") + "/";
		guiServerURL += "rpt?locale=" + localeStr;
		List<NaMaKeyValuePairsTokenizer.KeyValuePair> keyValuePairs = Arrays.asList(
				pair(PRM_QUESTIONS, CriteriaAndQuestionsURLParser.toURL(filledQuestions)), pair(PRM_ID, reportId),
				pair(PRM_PRINTING_OPTION, PrintingOption.NONE), pair(PRM_DOWNLOAD_PURPOSE, DownloadPurpose.PREVIEW),
				pair(PRM_OUTPUT_FORMAT, OutputFormat.PDF));
		guiServerURL += "&" + keyValuePairs.stream().map(p -> p.getKey() + "=" + p.getValue()).collect(Collectors.joining("&"));
		guiServerURL += "&" + "runWithNoAuth=true";
		return guiServerURL;
	}

	public String toResultLink(String guiServerURL)
	{
		return toLink(guiServerURL, PREFIX_REPORT_Result);
	}

	public String toLaunchLink(String guiServerURL)
	{
		return toLink(guiServerURL, PREFIX_LAUNCH_REPORT);
	}

	public String toLink(String guiServerURL, String prefix)
	{
		return guiServerURL + tokenize(prefix, pair(PRM_QUESTIONS, CriteriaAndQuestionsURLParser.toURL(filledQuestions)), pair(PRM_ID, reportId),
				pair(PRM_PRINTING_OPTION, PrintingOption.NONE), pair(PRM_DOWNLOAD_PURPOSE, DownloadPurpose.PREVIEW));
	}

	public Parameter copyParams(Object reportParameters)
	{
		return copyParams();
	}

	public Parameter copyParams()
	{
		for (QuestionField question : reportMetada.getQuestionFields())
		{
			ReportQuestionFieldMetadata questionMetdata = HasIDUtil.find(question.getId(), reportMetada.getMetadata());
			if (ObjectChecker.isEmptyOrNull(questionMetdata.getSourceParameter()))
			{
				p(question.getId()).v("@" + question.getId());
			}
		}
		return p;
	}

	public EntityReferenceData getReportReference()
	{
		return reportReference;
	}

	public String shorten(String server, String signature)
	{
		return ServerNamaRep.shortenURL(server, signature, toString());
	}
}
