package com.namasoft.common.utilities;

import java.io.*;

public class CommonFilesUtil
{
	public static void copyFileUsingStream(InputStream is, File dest) throws IOException
	{
		OutputStream os = null;
		try
		{
			os = new FileOutputStream(dest);
			byte[] buffer = new byte[1024];
			int length;
			while ((length = is.read(buffer)) > 0)
			{
				os.write(buffer, 0, length);
			}
		}
		finally
		{
			if (is != null)
				is.close();
			if (os != null)
				os.close();
		}
	}
}
