package com.namasoft.common.utilities;

import com.namasoft.common.constants.StringConstants;
import com.namasoft.common.fieldids.Fields;
import com.namasoft.common.flatobjects.FlatObject;
import com.namasoft.common.flatobjects.EntityReferenceData;

public class DimensionsUtil
{

	public static boolean isNullDimension(EntityReferenceData dim)
	{
		if (ObjectChecker.isEmptyOrNull(dim))
			return false;
		return ObjectChecker.areEqual(dim.getCode(), StringConstants.DIMENSION_NULL_CODE);
	}

	public static boolean isNotNullDimension(EntityReferenceData dim)
	{
		if (isNullDimension(dim))
			return false;
		return true;
	}

	public static boolean isNullDimension(FlatObject dim)
	{
		return ObjectChecker.areEqual(Fields.code(dim), StringConstants.DIMENSION_NULL_CODE);
	}

}
