package com.namasoft.common.utilities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class MultiKeyHash
{
	private List<Object> keys;

	public static MultiKeyHash of(Object... keys)
	{
		return new MultiKeyHash(keys);
	}

	public static MultiKeyHash of(List<Object> keys)
	{
		return new MultiKeyHash(keys);
	}

	public MultiKeyHash(Object... keys)
	{
		this.keys = CollectionsUtility.asList(keys);
	}

	public MultiKeyHash add(Object keyPart)
	{
		keys.add(keyPart);
		return this;
	}

	private MultiKeyHash(List<Object> keys)
	{
		this.keys = new ArrayList<>(keys);
	}

	@Override
	public boolean equals(Object obj)
	{
		if (obj instanceof MultiKeyHash)
			return keys.equals(((MultiKeyHash) obj).keys);
		return super.equals(obj);
	}

	@Override
	public int hashCode()
	{
		return keys.hashCode();
	}
	
	public List<Object> getKeys()
	{
		return keys;
	}

	public static MultiKeyHash ofNotEmpty(Object... keys)
	{
		return new MultiKeyHash(Arrays.stream(keys).filter(ObjectChecker::isNotEmptyOrNull).collect(Collectors.toList()));
	}
}