package com.namasoft.common.utilities;

import org.apache.logging.log4j.*;

import java.text.MessageFormat;

public class NaMaLogger
{

	private static Logger logger;
	private static Logger replicationLogger;
	private static Logger gui;
	private static Logger service;
	private static Logger performance;
	private static Logger reportPerformance;
	private static Logger cost;
	private static Logger mail;
	private static Logger security;
	private static Logger needsFix;

	private static void initLoggersIfNeeded()
	{
		if (logger != null)
			return;
		LoggingConfigurator.configureUsingCode(false);
		logger = LogManager.getLogger("namasoft.normal");
		replicationLogger = LogManager.getLogger("namasoft.replication");
		gui = LogManager.getLogger("namasoft.level2.gui");
		service = LogManager.getLogger("namasoft.level2.service");
		performance = LogManager.getLogger("namasoft.level2.performance");
		reportPerformance = LogManager.getLogger("namasoft.level2.reportPerformance");
		cost = LogManager.getLogger("namasoft.cost");
		mail = LogManager.getLogger("namasoft.mail");
		security = LogManager.getLogger("namasoft.security");
		needsFix = LogManager.getLogger("namasoft.needsfix");
	}

	public static void warn(String message, Object... arguments)
	{
		initLoggersIfNeeded();
		logger.warn(MessageFormat.format(message, arguments));
	}

	public static void warn(Object o, Throwable t)
	{
		initLoggersIfNeeded();
		logger.warn(o, t);
	}

	public static void warn(Throwable t)
	{
		initLoggersIfNeeded();
		logger.warn("", t);
	}

	public static void errorWithException(Throwable e, String message, Object... arguments)
	{
		error(MessageFormat.format(message, arguments), e);
	}
	public static void error(String message, Object... arguments)
	{
		initLoggersIfNeeded();
		logger.error(MessageFormat.format(message, arguments));
	}

	public static void errorWithTrace(String message, Object... arguments)
	{
		initLoggersIfNeeded();
		logger.error(MessageFormat.format(message, arguments), new PrintTrace());
	}

	public static void costError(String message, Object... arguments)
	{
		initLoggersIfNeeded();
		cost.error(MessageFormat.format(message, arguments));
	}

	public static void costInfo(String message, Object... arguments)
	{
		initLoggersIfNeeded();
		cost.info(MessageFormat.format(message, arguments));
	}

	public static void emailError(Exception e)
	{
		initLoggersIfNeeded();
		mail.error("", e);
	}

	public static void security(Exception e, String message, Object... arguments)
	{
		initLoggersIfNeeded();
		security.error(MessageFormat.format(message, arguments), e);
	}

	public static void needsFix(NullPointerException e)
	{
		initLoggersIfNeeded();
		needsFix.error("This is an error that needs to be fixed", e);
	}

	private static class PrintTrace extends Throwable
	{
	}

	public static void info(String message, Object... arguments)
	{
		initLoggersIfNeeded();
		logger.info(MessageFormat.format(message, arguments));
	}

	public static void error(Throwable e)
	{
		initLoggersIfNeeded();
		logger.error("", e);
	}

	public static void replicationError(Throwable e)
	{
		initLoggersIfNeeded();
		replicationLogger.error("****REPL****ERROR**", e);
	}

	public static void replicationEerror(String error)
	{
		initLoggersIfNeeded();
		replicationLogger.error("****REPL****ERROR**" + error);
	}

	public static void debug(String message, Object... arguments)
	{
		initLoggersIfNeeded();
		logger.debug(MessageFormat.format(message, arguments));
	}

	public static void debug(Throwable e)
	{
		initLoggersIfNeeded();
		logger.debug("", e);
	}

	public static void debug(Object o)
	{
		initLoggersIfNeeded();
		logger.debug(o);
	}

	public static void info(Object o)
	{
		initLoggersIfNeeded();
		logger.info(o);
	}

	public static void error(Object o)
	{
		initLoggersIfNeeded();
		logger.error(o);
	}

	public static void debug(Object o, Throwable t)
	{
		initLoggersIfNeeded();
		logger.debug(o, t);
	}

	public static void error(Object o, Throwable t)
	{
		error(o);
		error(t);
	}

	public static void info(Object o, Throwable t)
	{
		initLoggersIfNeeded();
		logger.info(o, t);
	}

	public static String msg(String msg, Object... args)
	{
		initLoggersIfNeeded();
		return MessageFormat.format(msg, args);
	}

	public static void guiError(Throwable e)
	{
		initLoggersIfNeeded();
		gui.error("", e);
	}

	public static void serviceError(Throwable e)
	{
		initLoggersIfNeeded();
		service.error("", e);
	}

	public static void performance(String msg, Object... args)
	{
		initLoggersIfNeeded();
		performance.info(msg(msg, args));
	}
	public static void reportPerformance(String msg, Object... args)
	{
		initLoggersIfNeeded();
		reportPerformance.info(msg(msg, args));
	}
}
