package com.namasoft.common.utilities;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public interface NamaUtil
{
	Map<Class<?>, AtomicBoolean> runningUtils = new ConcurrentHashMap<>();

	default Class<?> atomicUtilKey()
	{
		return getClass();
	}

	default AtomicBoolean atomicUtil()
	{
		return runningUtils.computeIfAbsent(atomicUtilKey(), k -> new AtomicBoolean(false));
	}

	Object apply(Object... params);
}
